/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.datagen;

import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "wildfields", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (String name : ModBlockSetsHelper.WOOD_NAMES) {
            this.blockWithItem(ModBlockSetsHelper.WOODEN_PLANKS.get(name));
            this.stairsBlock((StairBlock)ModBlockSetsHelper.WOODEN_STAIRS.get(name).get(), this.blockTexture((Block)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get()));
            this.slabBlock((SlabBlock)ModBlockSetsHelper.WOODEN_SLABS.get(name).get(), this.blockTexture((Block)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get()), this.blockTexture((Block)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get()));
            this.buttonBlock((ButtonBlock)ModBlockSetsHelper.WOODEN_BUTTONS.get(name).get(), this.blockTexture((Block)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get()));
            this.pressurePlateBlock((PressurePlateBlock)ModBlockSetsHelper.WOODEN_PRESSURE_PLATES.get(name).get(), this.blockTexture((Block)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get()));
            this.fenceBlock((FenceBlock)ModBlockSetsHelper.WOODEN_FENCES.get(name).get(), this.blockTexture((Block)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get()));
            this.fenceGateBlock((FenceGateBlock)ModBlockSetsHelper.WOODEN_FENCE_GATES.get(name).get(), this.blockTexture((Block)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get()));
            this.doorBlockWithRenderType((DoorBlock)ModBlockSetsHelper.WOODEN_DOORS.get(name).get(), this.modLoc("block/" + name + "_door_bottom"), this.modLoc("block/" + name + "_door_top"), "cutout");
            this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlockSetsHelper.WOODEN_TRAPDOORS.get(name).get(), this.modLoc("block/" + name + "_trapdoor"), true, "cutout");
            this.blockItem(ModBlockSetsHelper.WOODEN_STAIRS.get(name));
            this.blockItem(ModBlockSetsHelper.WOODEN_SLABS.get(name));
            this.blockItem(ModBlockSetsHelper.WOODEN_PRESSURE_PLATES.get(name));
            this.blockItem(ModBlockSetsHelper.WOODEN_FENCE_GATES.get(name));
            this.blockItem(ModBlockSetsHelper.WOODEN_TRAPDOORS.get(name), "_bottom");
            this.logBlock((RotatedPillarBlock)ModBlockSetsHelper.LOGS.get(name).get());
            this.axisBlock((RotatedPillarBlock)ModBlockSetsHelper.WOODS.get(name).get(), this.blockTexture((Block)ModBlockSetsHelper.LOGS.get(name).get()), this.blockTexture((Block)ModBlockSetsHelper.LOGS.get(name).get()));
            this.logBlock((RotatedPillarBlock)ModBlockSetsHelper.STRIPPED_LOGS.get(name).get());
            this.axisBlock((RotatedPillarBlock)ModBlockSetsHelper.STRIPPED_WOODS.get(name).get(), this.blockTexture((Block)ModBlockSetsHelper.STRIPPED_LOGS.get(name).get()), this.blockTexture((Block)ModBlockSetsHelper.STRIPPED_LOGS.get(name).get()));
            this.blockItem(ModBlockSetsHelper.LOGS.get(name));
            this.blockItem(ModBlockSetsHelper.WOODS.get(name));
            this.blockItem(ModBlockSetsHelper.STRIPPED_LOGS.get(name));
            this.blockItem(ModBlockSetsHelper.STRIPPED_WOODS.get(name));
            this.leavesBlock(ModBlockSetsHelper.LEAVES.get(name));
            this.saplingBlock(ModBlockSetsHelper.WOODEN_SAPLINGS.get(name));
            this.signBlock((StandingSignBlock)ModBlockSetsHelper.WOODEN_SIGNS.get(name).get(), (WallSignBlock)ModBlockSetsHelper.WOODEN_WALL_SIGNS.get(name).get(), this.blockTexture((Block)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get()));
            this.hangingSignBlock((Block)ModBlockSetsHelper.WOODEN_HANGING_SIGNS.get(name).get(), (Block)ModBlockSetsHelper.WOODEN_WALL_HANGING_SIGNS.get(name).get(), this.blockTexture((Block)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get()));
        }
        for (String name : ModBlockSetsHelper.STONE_NAMES) {
            for (String type : ModBlockSetsHelper.STONE_TYPES) {
                this.blockWithItem(ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type));
                this.blockItem(ModBlockSetsHelper.STONE_SLABS.get(name).get(type));
                this.blockItem(ModBlockSetsHelper.STONE_STAIRS.get(name).get(type));
                this.stairsBlock((StairBlock)ModBlockSetsHelper.STONE_STAIRS.get(name).get(type).get(), this.blockTexture((Block)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()));
                this.slabBlock((SlabBlock)ModBlockSetsHelper.STONE_SLABS.get(name).get(type).get(), this.blockTexture((Block)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()), this.blockTexture((Block)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()));
                this.wallBlock((WallBlock)ModBlockSetsHelper.STONE_WALLS.get(name).get(type).get(), this.blockTexture((Block)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()));
            }
        }
        for (String name : ModBlockSetsHelper.CROP_NAMES) {
            this.blockItem(ModBlockSetsHelper.HAY_BLOCKS.get(name));
            this.makeCrop((Block)ModBlockSetsHelper.CROPS.get(name).get(), name + "_stage", BlockStateProperties.AGE_7, 0, 7);
            this.axisBlock((RotatedPillarBlock)ModBlockSetsHelper.HAY_BLOCKS.get(name).get(), this.modLoc("block/" + name + "_hay_block_side"), this.modLoc("block/" + name + "_hay_block_top"));
        }
        for (String name : ModBlockSetsHelper.WILD_CROP_NAMES) {
            this.simpleBlock((Block)ModBlockSetsHelper.WILD_CROPS.get(name).get(), (ModelFile)((BlockModelBuilder)this.models().cross("wild_" + name, this.modLoc("block/wild_" + name))).renderType("cutout"));
        }
        this.makeCrossPlantBlock((Block)ModBlocks.FEATHER_GRASS.get(), false);
        this.makeCrossPlantBlock((Block)ModBlocks.TINY_GRASS.get(), true);
        this.makeCrossPlantBlock((Block)ModBlocks.THYME.get(), false);
        this.makeCrossPlantBlock((Block)ModBlocks.SPIDER_MILKWEED.get(), false);
        this.makeCrossPlantBlock((Block)ModBlocks.WORMWOOD.get(), false);
        this.makeCrossPlantBlock((Block)ModBlocks.SMOOTH_ASTER.get(), false);
        this.makeCrossPlantBlock((Block)ModBlocks.PRAIRIE_ROSE.get(), false);
        this.simpleBlock((Block)ModBlocks.POTTED_THYME.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_thyme", this.mcLoc("block/flower_pot_cross"), "plant", this.modLoc("block/thyme"))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.POTTED_SPIDER_MILKWEED.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_spider_milkweed", this.mcLoc("block/flower_pot_cross"), "plant", this.modLoc("block/spider_milkweed"))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.POTTED_WORMWOOD.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_wormwood", this.mcLoc("block/flower_pot_cross"), "plant", this.modLoc("block/thyme"))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.POTTED_SMOOTH_ASTER.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_smooth_aster", this.mcLoc("block/flower_pot_cross"), "plant", this.modLoc("block/smooth_aster"))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.POTTED_PRAIRIE_ROSE.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_prairie_rose", this.mcLoc("block/flower_pot_cross"), "plant", this.modLoc("block/prairie_rose"))).renderType("cutout"));
        this.doublePlantBlock((DoublePlantBlock)ModBlocks.BLUE_GRAMA_GRASS.get(), "blue_grama_grass", true);
        for (String name : ModBlockSetsHelper.BUSHES_NAMES) {
            this.bushBlock((Block)ModBlockSetsHelper.BUSHES.get(name).get());
        }
    }

    private void makeCrossPlantBlock(Block block, boolean isTinted) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockName(block), this.mcLoc("block/" + (isTinted ? "tinted_" : "") + "cross"))).texture("cross", this.modLoc("block/" + this.blockName(block)))).renderType("cutout"));
    }

    private void bushBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)BlockStateProperties.AGE_3);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block) + "_stage" + age, this.modLoc("block/" + this.blockName(block) + "_stage" + age))).renderType("cutout")).build();
        });
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).getPath();
    }

    private void doublePlantBlock(DoublePlantBlock block, String name, boolean isTinted) {
        ResourceLocation parent = isTinted ? this.mcLoc("block/tinted_cross") : this.mcLoc("block/cross");
        ModelBuilder bottomModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_bottom", parent)).texture("cross", this.modLoc("block/" + name + "_bottom"))).renderType("cutout");
        ModelBuilder topModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_top", parent)).texture("cross", this.modLoc("block/" + name + "_top"))).renderType("cutout");
        this.getVariantBuilder((Block)block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$doublePlantBlock$1((ModelFile)topModel, (ModelFile)bottomModel, arg_0));
    }

    private void makeCrop(Block block, String texturePrefix, IntegerProperty ageProperty, int minAge, int maxAge) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)ageProperty);
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().crop(this.blockName(block) + "_stage" + age, this.modLoc("block/" + texturePrefix + age))).build();
        });
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(signBlock.getDescriptionId(), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private void saplingBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cross(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void leavesBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), ResourceLocation.parse((String)"minecraft:block/leaves"), "all", this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void blockItem(RegistryObject<? extends Block> blockRegistryObject) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("wildfields:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath()));
    }

    private void blockItem(RegistryObject<? extends Block> blockRegistryObject, String appendix) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("wildfields:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath() + appendix));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$doublePlantBlock$1(ModelFile topModel, ModelFile bottomModel, BlockState state) {
        boolean upper = state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER;
        return ConfiguredModel.builder().modelFile(upper ? topModel : bottomModel).build();
    }
}

