/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.alminoris.wildfields.entity.client.AnimalGeoModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class AnimalGeoRenderer<T extends Animal>
extends GeoEntityRenderer<T> {
    private final ItemRenderer itemRenderer;
    private final float scale;
    private final float babyScale;
    private final boolean hasHorns;
    private final boolean hasItemRenderer;

    public AnimalGeoRenderer(EntityRendererProvider.Context renderManager, float scale, float babyScale, boolean hasHorns, boolean hasItemRenderer) {
        super(renderManager, new AnimalGeoModel());
        this.itemRenderer = renderManager.getItemRenderer();
        this.scale = scale;
        this.babyScale = babyScale;
        this.hasHorns = hasHorns;
        this.hasItemRenderer = hasItemRenderer;
    }

    protected String resolveName(T animatable) {
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)animatable.getType());
        if (key != null) {
            return key.getPath();
        }
        return animatable.getEncodeId();
    }

    public ResourceLocation getTextureLocation(T animatable) {
        String name = this.resolveName(animatable);
        return ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("textures/entity/" + name + ".png"));
    }

    public void postRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (this.hasItemRenderer) {
            this.renderHeldItem(animatable, poseStack, bufferSource, packedLight);
        }
        super.postRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (animatable.isBaby()) {
            poseStack.scale(this.babyScale, this.babyScale, this.babyScale);
            if (this.hasHorns) {
                ((GeoBone)model.getBone("horn1").get()).setHidden(true);
                ((GeoBone)model.getBone("horn2").get()).setHidden(true);
            }
        } else {
            poseStack.scale(this.scale, this.scale, this.scale);
            if (this.hasHorns) {
                ((GeoBone)model.getBone("horn1").get()).setHidden(false);
                ((GeoBone)model.getBone("horn2").get()).setHidden(false);
            }
        }
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    private void renderHeldItem(T entity, PoseStack matrices, MultiBufferSource bufferSource, int light) {
        ItemStack itemStack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (!itemStack.isEmpty()) {
            BakedModel model = this.itemRenderer.getModel(itemStack, entity.level(), entity, 0);
            matrices.pushPose();
            matrices.translate(0.0, 0.5, 0.0);
            matrices.scale(0.5f, 0.5f, 0.5f);
            this.itemRenderer.render(itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, matrices, bufferSource, light, 0, model);
            matrices.popPose();
        }
    }
}

