/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.alminoris.wildfields.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class BisonEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> DATA_EATING = SynchedEntityData.defineId(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int EAT_DURATION = 200;
    private static int globalEatInterval = 3600;
    private int eatingTimer = globalEatInterval;

    public BisonEntity(EntityType<? extends BisonEntity> type, Level level) {
        super(type, level);
        this.moveControl = new MoveControl((Mob)this);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.ARMOR, 15.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_SPEED, 0.75);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 0.85));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 0.8, stack -> stack.is(ModTags.Items.BISON_FOOD), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 0.75));
        this.goalSelector.addGoal(5, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.75));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 7.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_EATING, (Object)false);
    }

    public boolean isEating() {
        return (Boolean)this.entityData.get(DATA_EATING);
    }

    public void setEating(boolean eating) {
        this.entityData.set(DATA_EATING, (Object)eating);
        this.setPose(eating ? Pose.SITTING : Pose.STANDING);
        if (eating) {
            this.getNavigation().stop();
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("IsEating", this.isEating());
        compound.putInt("EatingTimer", this.eatingTimer);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("IsEating")) {
            this.setEating(compound.getBoolean("IsEating"));
        }
        if (compound.contains("EatingTimer")) {
            this.eatingTimer = compound.getInt("EatingTimer");
        }
    }

    protected void dropFromLootTable(DamageSource pSource, boolean pRecentlyHit) {
        int count;
        super.dropFromLootTable(pSource, pRecentlyHit);
        RandomSource rnd = this.level().random;
        if (rnd.nextFloat() < 0.05f && (count = rnd.nextInt(2)) > 0) {
            this.spawnAtLocation((ItemLike)ModItems.BISON_HORN.get(), count);
        }
        if (rnd.nextFloat() < 0.5f && (count = rnd.nextInt(5)) > 0) {
            this.spawnAtLocation((ItemLike)ModItems.BISON.get(), count);
        }
        if (rnd.nextFloat() < 0.25f && (count = rnd.nextInt(7)) > 0) {
            this.spawnAtLocation((ItemLike)Items.LEATHER, count);
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.SOUND_BISON_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource dmg) {
        return (SoundEvent)ModSounds.SOUND_BISON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SOUND_BISON_DEATH.get();
    }

    @Nullable
    public BisonEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageable) {
        EntityType type = (EntityType)ModEntities.BISON.get();
        Entity entity = type.create((Level)serverLevel);
        if (entity instanceof BisonEntity) {
            return (BisonEntity)entity;
        }
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ModTags.Items.BISON_FOOD);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (globalEatInterval <= 0) {
                globalEatInterval = 3600 + this.random.nextInt(2401);
            }
            if (!this.isEating() && this.eatingTimer > 0) {
                --this.eatingTimer;
            } else if (!this.isEating() && this.eatingTimer <= 0) {
                this.setEating(true);
                this.eatingTimer = 200;
            }
            if (this.isEating() && this.eatingTimer > 0) {
                --this.eatingTimer;
            } else if (this.isEating() && this.eatingTimer <= 0) {
                this.setEating(false);
                this.eatingTimer = globalEatInterval = 3600 + this.random.nextInt(2401);
            }
            if (this.isEating() && this.isInWater()) {
                this.setEating(false);
                this.eatingTimer = globalEatInterval = 3600 + this.random.nextInt(2401);
            }
        }
    }

    public void travel(Vec3 pTravelVector) {
        if (this.isEating()) {
            this.setDeltaMovement(Vec3.ZERO);
            return;
        }
        super.travel(pTravelVector);
    }

    public boolean canBeLeashed() {
        return true;
    }

    public static <T extends Animal> boolean isValidNaturalSpawn(EntityType<T> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean lightOk = Mob.checkMobSpawnRules(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
        boolean isSpawnableBlock = world.getBlockState(pos.below()).is(ModTags.Blocks.BISON_SPAWNABLE_ON);
        return lightOk && isSpawnableBlock;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack item = player.getItemInHand(hand);
        if (this.isFood(item)) {
            return super.mobInteract(player, hand);
        }
        return InteractionResult.PASS;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (pose == Pose.SITTING) {
            return EntityDimensions.scalable((float)this.getType().getWidth(), (float)(this.getType().getHeight() - 0.5f));
        }
        return super.getDefaultDimensions(pose);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.isAggressive()) {
                return state.setAndContinue(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            }
            if (this.isEating()) {
                return state.setAndContinue(RawAnimation.begin().then("eating", Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getMaxSpawnClusterSize() {
        return 7;
    }
}

