/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import java.util.UUID;
import java.util.function.Predicate;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.custom.SaigaEntity;
import net.alminoris.wildfields.sound.ModSounds;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class CoyoteEntity
extends TamableAnimal
implements GeoEntity,
NeutralMob {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_ANGER_TIME = SynchedEntityData.defineId(CoyoteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final Predicate<LivingEntity> FOLLOW_TAMED_PREDICATE = entity -> {
        EntityType entityType = entity.getType();
        return entityType == ModEntities.WHITE_TAILED_JACKRABBIT.get() || entityType == EntityType.RABBIT || entityType == ModEntities.PALLID_WINGED_GRASSHOPPER.get();
    };
    private static final int ANGER_MIN = 400;
    private static final int ANGER_MAX = 780;
    @Nullable
    private UUID angryAt;

    public CoyoteEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_SPEED, 1.25).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 5.5);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.7f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::isAngryAt));
        this.targetSelector.addGoal(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, FOLLOW_TAMED_PREDICATE));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, SaigaEntity.class, false, SaigaEntity.BABY_SAIGA));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ANGER_TIME, (Object)0);
    }

    public boolean hasAngerTime() {
        return this.getRemainingPersistentAngerTime() > 0;
    }

    protected SoundEvent getAmbientSound() {
        if (this.hasAngerTime()) {
            return (SoundEvent)ModSounds.SOUND_COYOTE_GROWL.get();
        }
        if (this.random.nextInt(3) == 0) {
            return this.isTame() && this.getHealth() < 20.0f ? (SoundEvent)ModSounds.SOUND_COYOTE_WHINE.get() : (SoundEvent)ModSounds.SOUND_COYOTE_AMBIENT.get();
        }
        return (SoundEvent)ModSounds.SOUND_COYOTE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_COYOTE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SOUND_COYOTE_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.5f;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.MEAT);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mate) {
        CoyoteEntity child = (CoyoteEntity)((EntityType)ModEntities.COYOTE.get()).create((Level)level);
        if (child != null && mate instanceof CoyoteEntity) {
            CoyoteEntity mateCoyote = (CoyoteEntity)mate;
            if (this.isTame()) {
                child.setOwnerUUID(this.getOwnerUUID());
                child.setTame(true, true);
            }
        }
        return child;
    }

    public boolean canMate(Animal other) {
        if (!(other instanceof CoyoteEntity)) {
            return false;
        }
        CoyoteEntity otherCoyote = (CoyoteEntity)other;
        return this.isTame() && otherCoyote.isTame() && this.isInLove() && otherCoyote.isInLove();
    }

    protected void dropFromLootTable(DamageSource source, boolean causedByPlayer) {
        super.dropFromLootTable(source, causedByPlayer);
        if (this.random.nextFloat() < 0.2f) {
            this.spawnAtLocation((ItemLike)Items.BONE);
        }
    }

    public void aiStep() {
        if (this.isSleeping()) {
            this.yBodyRot = this.yBodyRotO;
            return;
        }
        super.aiStep();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(DATA_ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID getAngryAt() {
        return this.angryAt;
    }

    public boolean isAngryAt(LivingEntity p_21675_) {
        return super.isAngryAt(p_21675_);
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
        this.angryAt = uuid;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angryAt;
    }

    public void startPersistentAngerTimer() {
        RandomSource random = this.level().getRandom();
        this.setRemainingPersistentAngerTime(random.nextInt(380) + 400);
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        Item item = itemstack.getItem();
        if (!this.level().isClientSide || this.isBaby() && this.isFood(itemstack)) {
            if (this.isTame()) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    itemstack.consume(1, (LivingEntity)p_30412_);
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(2.0f * f);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                InteractionResult interactionresult = super.mobInteract(p_30412_, p_30413_);
                if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)p_30412_)) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    this.jumping = false;
                    this.navigation.stop();
                    this.setTarget(null);
                    return InteractionResult.SUCCESS_NO_ITEM_USED;
                }
                return interactionresult;
            }
            if (itemstack.is(Items.BONE) && !this.isAngry()) {
                itemstack.consume(1, (LivingEntity)p_30412_);
                this.tryToTame(p_30412_);
                return InteractionResult.SUCCESS;
            }
            return super.mobInteract(p_30412_, p_30413_);
        }
        boolean flag = this.isOwnedBy((LivingEntity)p_30412_) || this.isTame() || itemstack.is(Items.BONE) && !this.isTame() && !this.isAngry();
        return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    private void tryToTame(Player p_336244_) {
        if (this.random.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_336244_)) {
            this.tame(p_336244_);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.isOrderedToSit()) {
                return state.setAndContinue(RawAnimation.begin().then("sit", Animation.LoopType.HOLD_ON_LAST_FRAME));
            }
            if (this.isAggressive()) {
                return state.setAndContinue(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.6 * (double)this.getEyeHeight(), (double)this.getBbWidth() * 0.4);
    }

    public boolean canBeLeashed() {
        return !this.hasAngerTime();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide) {
            this.setOrderedToSit(false);
        }
        return super.hurt(source, amount);
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }
}

