/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.custom.ai.goal.EatHeldItemGoal;
import net.alminoris.wildfields.entity.custom.ai.goal.PickUpItemGoal;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.alminoris.wildfields.util.ModTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class MarmotEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean isPickUp = false;
    private static final int EXPLORE_DURATION = 400;
    private static int exploreInterval = 1800;
    private int exploreTimer = exploreInterval;
    private static final EntityDataAccessor<Boolean> DATA_EXPLORING = SynchedEntityData.defineId(MarmotEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public MarmotEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.moveControl = new MoveControl((Mob)this);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 9.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ARMOR, 0.5);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new PickUpItemGoal((PathfinderMob)this, 1.0, new Item[]{(Item)ModItems.OLIVES.get(), Items.SWEET_BERRIES, ((Block)ModBlocks.TINY_GRASS.get()).asItem(), Items.SHORT_GRASS, Items.WHEAT_SEEDS}){

            @Override
            public boolean canUse() {
                return !MarmotEntity.this.isExploring() && super.canUse();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new EatHeldItemGoal((Animal)this, new Item[]{((Block)ModBlocks.TINY_GRASS.get()).asItem(), Items.SHORT_GRASS, Items.WHEAT_SEEDS}){

            @Override
            public boolean canUse() {
                return !MarmotEntity.this.isExploring() && super.canUse();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 0.85));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 0.8, stack -> stack.is(ModTags.Items.MARMOT_FOOD), false));
        this.goalSelector.addGoal(7, (Goal)new FollowParentGoal((Animal)this, 0.75));
        this.goalSelector.addGoal(8, (Goal)new PanicGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.75));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_EXPLORING, (Object)false);
    }

    public boolean isExploring() {
        return (Boolean)this.entityData.get(DATA_EXPLORING);
    }

    public void setExploring(boolean explore) {
        this.entityData.set(DATA_EXPLORING, (Object)explore);
        this.setPose(explore ? Pose.SITTING : Pose.STANDING);
        if (explore) {
            this.getNavigation().stop();
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("IsExploring", this.isExploring());
        compound.putInt("ExploreTimer", this.exploreTimer);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("IsExploring")) {
            this.setExploring(compound.getBoolean("IsExploring"));
        }
        if (compound.contains("ExploreTimer")) {
            this.exploreTimer = compound.getInt("ExploreTimer");
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && !this.isOrderedToSit()) {
            exploreInterval = 3200 + this.random.nextInt(3801);
            if (!this.isExploring() && this.exploreTimer > 0) {
                --this.exploreTimer;
            } else if (!this.isExploring() && this.exploreTimer <= 0) {
                this.setExploring(true);
                this.exploreTimer = 400;
            }
            if (this.isExploring() && this.exploreTimer > 0) {
                --this.exploreTimer;
            } else if (this.isExploring() && this.exploreTimer <= 0) {
                this.setExploring(false);
                this.exploreTimer = exploreInterval;
            }
            if (this.isExploring() && this.isInWater()) {
                this.setExploring(false);
                this.exploreTimer = exploreInterval;
            }
        }
    }

    public void travel(Vec3 pVec) {
        if (this.isExploring()) {
            this.setDeltaMovement(Vec3.ZERO);
            return;
        }
        super.travel(pVec);
    }

    protected float getJumpPower() {
        return super.getJumpPower();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.SOUND_MARMOT_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_MARMOT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SOUND_MARMOT_DEATH.get();
    }

    @Nullable
    public MarmotEntity getBreedOffspring(ServerLevel level, AgeableMob mate) {
        Entity entity = ((EntityType)ModEntities.MARMOT.get()).create((Level)level);
        if (entity instanceof MarmotEntity) {
            return (MarmotEntity)entity;
        }
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ModTags.Items.MARMOT_FOOD);
    }

    protected void dropFromLootTable(DamageSource source, boolean causedByPlayer) {
        super.dropFromLootTable(source, causedByPlayer);
        RandomSource rnd = this.level().random;
        if (rnd.nextFloat() < 0.2f) {
            this.spawnAtLocation((ItemLike)ModItems.MARMOT_FUR.get());
        }
        if (rnd.nextFloat() < 0.05f) {
            this.spawnAtLocation((ItemLike)ModBlocks.TINY_GRASS.get());
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.level().isClientSide) {
            return InteractionResult.sidedSuccess((boolean)true);
        }
        if (this.isTame()) {
            if (this.isFood(stack) && this.getHealth() < this.getMaxHealth()) {
                stack.shrink(1);
                this.heal(2.0f);
                return InteractionResult.SUCCESS;
            }
            if (player.equals((Object)this.getOwner())) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
        } else if (stack.getItem() == Items.WHEAT_SEEDS && !this.isExploring()) {
            stack.shrink(1);
            if (this.random.nextInt(3) == 0) {
                this.tame(player);
                this.navigation.stop();
                this.setTarget(null);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.isOrderedToSit()) {
                return state.setAndContinue(RawAnimation.begin().then("sit", Animation.LoopType.HOLD_ON_LAST_FRAME));
            }
            if (this.isExploring()) {
                return state.setAndContinue(RawAnimation.begin().then("exploring", Animation.LoopType.PLAY_ONCE));
            }
            if (this.isPickUp) {
                this.isPickUp = false;
                return state.setAndContinue(RawAnimation.begin().then("pickup", Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void triggerPickUpAnimation() {
        this.isPickUp = true;
    }

    public void resetPickUpAnimation() {
        this.isPickUp = false;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (pose == Pose.SITTING) {
            return EntityDimensions.scalable((float)this.getType().getWidth(), (float)(this.getType().getHeight() - 0.5f));
        }
        return super.getDimensions(pose);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.setOrderedToSit(false);
        return super.hurt(source, amount);
    }

    public int getMaxSpawnClusterSize() {
        return 15;
    }
}

