/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import java.util.function.Predicate;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.alminoris.wildfields.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class SaigaEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final int EAT_DURATION = 200;
    private static int eatInterval = 3600;
    private int eatingTimer = eatInterval;
    private static final EntityDataAccessor<Boolean> IS_EATING = SynchedEntityData.defineId(SaigaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final Predicate<LivingEntity> BABY_SAIGA = LivingEntity::isBaby;

    public SaigaEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    protected void dropFromLootTable(DamageSource damageSource, boolean causedByPlayer) {
        super.dropFromLootTable(damageSource, causedByPlayer);
        if (this.random.nextFloat() < 0.05f) {
            this.spawnAtLocation(new ItemStack((ItemLike)ModItems.SAIGA_HORN.get(), this.random.nextInt(2)));
        }
        if (this.random.nextFloat() < 0.5f) {
            this.spawnAtLocation(new ItemStack((ItemLike)ModItems.SAIGA.get(), this.random.nextInt(5)));
        }
        if (this.random.nextFloat() < 0.25f) {
            this.spawnAtLocation(new ItemStack((ItemLike)Items.LEATHER, this.random.nextInt(3)));
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 25.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 0.85));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 0.8, stack -> stack.is(ModTags.Items.SAIGA_FOOD), false));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 0.75));
        this.goalSelector.addGoal(4, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 7.0f));
        super.registerGoals();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.SOUND_SAIGA_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_SAIGA_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SOUND_SAIGA_DEATH.get();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ModTags.Items.SAIGA_FOOD);
    }

    @Nullable
    public SaigaEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageable) {
        EntityType type = (EntityType)ModEntities.SAIGA.get();
        Entity entity = type.create((Level)serverLevel);
        if (entity instanceof SaigaEntity) {
            return (SaigaEntity)entity;
        }
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_EATING, (Object)false);
    }

    public boolean isEating() {
        return (Boolean)this.entityData.get(IS_EATING);
    }

    public void setEating(boolean sitting) {
        this.entityData.set(IS_EATING, (Object)sitting);
        this.setPose(sitting ? Pose.SITTING : Pose.STANDING);
        if (sitting) {
            this.getNavigation().stop();
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("IsEating", this.isEating());
        compound.putInt("EatingTimer", this.eatingTimer);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("IsEating")) {
            this.setEating(compound.getBoolean("IsEating"));
        }
        if (compound.contains("EatingTimer")) {
            this.eatingTimer = compound.getInt("EatingTimer");
        }
    }

    public void travel(Vec3 movementInput) {
        if (this.isEating()) {
            this.setDeltaMovement(Vec3.ZERO);
            return;
        }
        super.travel(movementInput);
    }

    public void aiStep() {
        if (this.isEating()) {
            this.yBodyRot = this.yBodyRotO;
            return;
        }
        super.aiStep();
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            eatInterval = 3600 + this.random.nextInt(2401);
            if (!this.isEating() && this.eatingTimer > 0) {
                --this.eatingTimer;
            } else if (!this.isEating() && this.eatingTimer <= 0) {
                this.setEating(true);
                this.eatingTimer = 200;
            }
            if (this.isEating() && this.eatingTimer > 0) {
                --this.eatingTimer;
            } else if (this.isEating() && this.eatingTimer <= 0) {
                this.setEating(false);
                this.eatingTimer = eatInterval;
            }
            if (this.isEating() && this.isInWater()) {
                this.setEating(false);
                this.eatingTimer = eatInterval;
            }
        }
    }

    public static <T extends Animal> boolean isValidNaturalSpawn(EntityType<T> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean lightOk = Mob.checkMobSpawnRules(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
        boolean isSpawnableBlock = world.getBlockState(pos.below()).is(ModTags.Blocks.SAIGA_SPAWNABLE_ON);
        return lightOk && isSpawnableBlock;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.isEating()) {
                return state.setAndContinue(RawAnimation.begin().then("eating", Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }));
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (pose == Pose.SITTING) {
            return EntityDimensions.scalable((float)this.getType().getWidth(), (float)(this.getType().getHeight() - 0.5f));
        }
        return super.getDefaultDimensions(pose);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getMaxSpawnClusterSize() {
        return 7;
    }
}

