/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.custom.MarmotEntity;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class SteppeEagleEntity
extends Animal
implements GeoEntity,
FlyingAnimal {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int featherDropCooldown = 1200;

    public SteppeEagleEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world);
        birdNavigation.setCanPassDoors(false);
        birdNavigation.setCanFloat(false);
        birdNavigation.setCanOpenDoors(true);
        return birdNavigation;
    }

    protected void checkFallDamage(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public boolean isPushable() {
        return true;
    }

    protected void dropFromLootTable(DamageSource damageSource, boolean causedByPlayer) {
        super.dropFromLootTable(damageSource, causedByPlayer);
        if (this.random.nextFloat() < 0.05f) {
            this.spawnAtLocation(new ItemStack((ItemLike)ModItems.STEPPE_EAGLE_BEAK.get(), 1));
        }
        if (this.random.nextFloat() < 0.25f) {
            this.spawnAtLocation(new ItemStack((ItemLike)ModItems.STEPPE_EAGLE_FEATHER.get(), 1));
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && !this.isBaby() && this.featherDropCooldown-- <= 0) {
            this.dropFeather();
            this.featherDropCooldown = 3600 + this.random.nextInt(2400);
        }
    }

    private void dropFeather() {
        if (this.isAlive() && !this.isInWaterOrBubble()) {
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)ModItems.STEPPE_EAGLE_FEATHER.get())));
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new HighAltitudeWanderGoal((PathfinderMob)this, 1.0, 200, 80, 0.05f));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 5.0f));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, MarmotEntity.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        super.registerGoals();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.SOUND_STEPPE_EAGLE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_STEPPE_EAGLE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SOUND_STEPPE_EAGLE_DEATH.get();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.RABBIT_FOOT);
    }

    @Nullable
    public SteppeEagleEntity getBreedOffspring(ServerLevel level, AgeableMob mate) {
        Entity entity = ((EntityType)ModEntities.STEPPE_EAGLE.get()).create((Level)level);
        if (entity instanceof SteppeEagleEntity) {
            return (SteppeEagleEntity)entity;
        }
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.isAggressive()) {
                return state.setAndContinue(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            }
            if (this.isFlying()) {
                return state.setAndContinue(RawAnimation.begin().then("flying", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public Vec3 getLeashOffset(float p_249286_) {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    static class HighAltitudeWanderGoal
    extends Goal {
        private final PathfinderMob mob;
        private final double speed;
        private final int maxHeight;
        private final int minHeight;
        private final float chance;
        private Vec3 target;
        private boolean descending = false;

        public HighAltitudeWanderGoal(PathfinderMob mob, double speed, int maxHeight, int minHeight, float chance) {
            this.mob = mob;
            this.speed = speed;
            this.maxHeight = maxHeight;
            this.minHeight = minHeight;
            this.chance = chance;
        }

        public boolean canUse() {
            if (this.mob.getNavigation().isDone() && this.mob.getRandom().nextFloat() < this.chance) {
                if (this.descending) {
                    this.target = this.findGroundTarget();
                    return this.target != null;
                }
                Level world = this.mob.level();
                double x = this.mob.getX() + this.mob.getRandom().nextGaussian() * 20.0;
                double z = this.mob.getZ() + this.mob.getRandom().nextGaussian() * 20.0;
                double y = Math.min(Math.max((double)this.minHeight, this.mob.getY() + this.mob.getRandom().nextGaussian() * 10.0), (double)this.maxHeight);
                this.target = new Vec3(x, y, z);
                return true;
            }
            return false;
        }

        public void start() {
            if (this.target != null) {
                this.mob.getNavigation().moveTo(this.target.x, this.target.y, this.target.z, this.speed);
            }
        }

        public boolean canContinueToUse() {
            if (this.descending) {
                return !this.mob.getNavigation().isDone() && this.mob.getY() > (double)this.mob.level().getMinBuildHeight();
            }
            return !this.mob.getNavigation().isDone() && this.target != null;
        }

        public void stop() {
            this.descending = !this.descending && this.mob.getY() >= (double)(this.maxHeight - 5);
            this.target = null;
        }

        private Vec3 findGroundTarget() {
            Level world = this.mob.level();
            RandomSource random = this.mob.getRandom();
            BlockPos groundPos = new BlockPos((int)(this.mob.getX() + random.nextGaussian() * 20.0), (int)this.mob.getY(), (int)(this.mob.getZ() + random.nextGaussian() * 20.0));
            if (world.getBlockState(groundPos = world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, groundPos)).isAir()) {
                return Vec3.atBottomCenterOf((Vec3i)groundPos);
            }
            return null;
        }
    }
}

