/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.alminoris.wildfields.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class SteppeViperEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public SteppeViperEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void dropFromLootTable(DamageSource damageSource, boolean causedByPlayer) {
        super.dropFromLootTable(damageSource, causedByPlayer);
        if (this.random.nextFloat() < 0.25f) {
            this.spawnAtLocation(new ItemStack((ItemLike)ModItems.STEPPE_VIPER_FANG.get(), (int)(Math.random() * 2.0)));
        }
    }

    public static <T extends Animal> boolean isValidNaturalSpawn(EntityType<T> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean lightOk = Mob.checkMobSpawnRules(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
        boolean isSpawnableBlock = world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON);
        boolean hasFlowersNearby = false;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                mutablePos.set(pos.getX() + dx, pos.getY() - 1, pos.getZ() + dz);
                if (!world.getBlockState(mutablePos.above()).is(ModTags.Blocks.STEPPE_VIPER_PLANTS)) continue;
                hasFlowersNearby = true;
                break;
            }
            if (hasFlowersNearby) break;
        }
        return lightOk && hasFlowersNearby && isSpawnableBlock;
    }

    public boolean hasEffect(Holder<MobEffect> p_329256_) {
        return super.hasEffect(p_329256_);
    }

    public boolean addEffect(MobEffectInstance effect, @Nullable Entity entity) {
        if (effect.getEffect() == MobEffects.POISON) {
            return false;
        }
        return super.addEffect(effect, entity);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_SPEED, 1.4).add(Attributes.MOVEMENT_SPEED, 0.35);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.15, false){

            protected void checkAndPerformAttack(LivingEntity target) {
                if (this.canPerformAttack(target)) {
                    target.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 2));
                }
                super.checkAndPerformAttack(target);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, stack -> stack.is(Items.RABBIT), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.5f));
        this.goalSelector.addGoal(7, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 4.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true));
        super.registerGoals();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.SOUND_STEPPE_VIPER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_STEPPE_VIPER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SOUND_STEPPE_VIPER_DEATH.get();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.RABBIT);
    }

    @Nullable
    public SteppeViperEntity getBreedOffspring(ServerLevel level, AgeableMob mate) {
        Entity entity = ((EntityType)ModEntities.STEPPE_VIPER.get()).create((Level)level);
        if (entity instanceof SteppeViperEntity) {
            return (SteppeViperEntity)entity;
        }
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.isAggressive()) {
                return state.setAndContinue(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

