/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class WhiteTailedJackrabbitEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int jumpTicks;
    private int jumpDuration;
    private boolean lastOnGround;
    private int ticksUntilJump;
    int moreBeetrootTicks;

    public WhiteTailedJackrabbitEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.jumpControl = new WhiteTailedJackrabbitJumpControl(this);
        this.moveControl = new WhiteTailedJackrabbitMoveControl(this);
        this.setSpeed(0.0);
    }

    protected void dropFromLootTable(DamageSource damageSource, boolean causedByPlayer) {
        super.dropFromLootTable(damageSource, causedByPlayer);
        this.spawnAtLocation(new ItemStack((ItemLike)ModItems.JACKRABBIT.get(), 1));
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ARMOR, 1.5);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new EatBeetrootCropGoal(this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 0.85));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 0.8, stack -> stack.is(Items.BEETROOT), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 0.75));
        this.goalSelector.addGoal(5, (Goal)new EscapeDangerGoal(this, 1.5));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        super.registerGoals();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.SOUND_WHITE_TAILED_JACKRABBIT_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_WHITE_TAILED_JACKRABBIT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SOUND_WHITE_TAILED_JACKRABBIT_DEATH.get();
    }

    @Nullable
    public WhiteTailedJackrabbitEntity getBreedOffspring(ServerLevel level, AgeableMob mate) {
        Entity entity = ((EntityType)ModEntities.WHITE_TAILED_JACKRABBIT.get()).create((Level)level);
        if (entity instanceof WhiteTailedJackrabbitEntity) {
            return (WhiteTailedJackrabbitEntity)entity;
        }
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.BEETROOT);
    }

    public static <T extends Animal> boolean isValidNaturalSpawn(EntityType<T> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean lightOk = Mob.checkMobSpawnRules(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
        boolean isSpawnableBlock = world.getBlockState(pos.below()).is(BlockTags.RABBITS_SPAWNABLE_ON);
        return lightOk && isSpawnableBlock;
    }

    protected float getJumpPower() {
        Path path;
        float f = 0.35f;
        if (this.horizontalCollision || this.moveControl.hasWanted() && this.moveControl.getWantedY() > this.getY() + 0.5) {
            f = 0.6f;
        }
        if ((path = this.navigation.getPath()) != null && !path.isDone()) {
            Vec3 vec3d = path.getNextEntityPos((Entity)this);
            if (vec3d.y > this.getY() + 0.5) {
                f = 0.6f;
            }
        }
        if (this.moveControl.getSpeedModifier() <= 0.6) {
            f = 0.25f;
        }
        return super.getJumpPower(f / 0.42f);
    }

    public void jumpFromGround() {
        double e;
        super.jumpFromGround();
        double d = this.moveControl.getSpeedModifier();
        if (d > 0.0 && (e = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)1);
        }
    }

    public void setSpeed(double speed) {
        this.getNavigation().setSpeedModifier(speed);
        this.moveControl.setWantedPosition(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ(), speed);
    }

    public void setJumping(boolean jumping) {
        super.setJumping(jumping);
        if (jumping) {
            this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJump() {
        this.setJumping(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void customServerAiStep() {
        if (this.ticksUntilJump > 0) {
            --this.ticksUntilJump;
        }
        if (this.moreBeetrootTicks > 0) {
            this.moreBeetrootTicks -= this.random.nextInt(3);
            if (this.moreBeetrootTicks < 0) {
                this.moreBeetrootTicks = 0;
            }
        }
        if (this.onGround()) {
            WhiteTailedJackrabbitJumpControl rabbitJumpControl;
            if (!this.lastOnGround) {
                this.setJumping(false);
                this.scheduleJump();
            }
            if (!(rabbitJumpControl = (WhiteTailedJackrabbitJumpControl)this.jumpControl).isActive()) {
                if (this.moveControl.hasWanted() && this.ticksUntilJump == 0) {
                    Path path = this.navigation.getPath();
                    Vec3 vec3d = new Vec3(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ());
                    if (path != null && !path.isDone()) {
                        vec3d = path.getNextEntityPos((Entity)this);
                    }
                    this.lookTowards(vec3d.x, vec3d.z);
                    this.startJump();
                }
            } else if (!rabbitJumpControl.canJump()) {
                this.enableJump();
            }
        }
        this.lastOnGround = this.onGround();
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    private void lookTowards(double x, double z) {
        this.setYRot((float)(Mth.atan2((double)(z - this.getZ()), (double)(x - this.getX())) * 180.0 / 3.1415927410125732) - 90.0f);
    }

    private void enableJump() {
        ((WhiteTailedJackrabbitJumpControl)this.jumpControl).setCanJump(true);
    }

    private void disableJump() {
        ((WhiteTailedJackrabbitJumpControl)this.jumpControl).setCanJump(false);
    }

    private void doScheduleJump() {
        this.ticksUntilJump = this.moveControl.getSpeedModifier() < 2.2 ? 10 : 1;
    }

    private void scheduleJump() {
        this.doScheduleJump();
        this.disableJump();
    }

    public void aiStep() {
        super.aiStep();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.setJumping(false);
        }
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.RABBIT_JUMP;
    }

    boolean wantsBeetroots() {
        return this.moreBeetrootTicks <= 0;
    }

    public void handleEntityEvent(byte status) {
        if (status == 1) {
            this.spawnSprintParticle();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.handleEntityEvent(status);
        }
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getMaxSpawnClusterSize() {
        return 12;
    }

    public static class WhiteTailedJackrabbitJumpControl
    extends JumpControl {
        private final WhiteTailedJackrabbitEntity whiteTailedJackrabbitEntity;
        private boolean canJump;

        public WhiteTailedJackrabbitJumpControl(WhiteTailedJackrabbitEntity rabbit) {
            super((Mob)rabbit);
            this.whiteTailedJackrabbitEntity = rabbit;
        }

        public boolean isActive() {
            return this.jump;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJump) {
            this.canJump = canJump;
        }

        public void tick() {
            if (this.jump) {
                this.whiteTailedJackrabbitEntity.startJump();
                this.jump = false;
            }
        }
    }

    static class WhiteTailedJackrabbitMoveControl
    extends MoveControl {
        private final WhiteTailedJackrabbitEntity whiteTailedJackrabbitEntity;
        private double whiteTailedJackrabbitSpeed;

        public WhiteTailedJackrabbitMoveControl(WhiteTailedJackrabbitEntity owner) {
            super((Mob)owner);
            this.whiteTailedJackrabbitEntity = owner;
        }

        public void tick() {
            if (this.whiteTailedJackrabbitEntity.onGround() && !this.whiteTailedJackrabbitEntity.jumping && !((WhiteTailedJackrabbitJumpControl)this.whiteTailedJackrabbitEntity.jumpControl).isActive()) {
                this.whiteTailedJackrabbitEntity.setSpeed(0.0);
            } else if (this.hasWanted()) {
                this.whiteTailedJackrabbitEntity.setSpeed(this.whiteTailedJackrabbitSpeed);
            }
            super.tick();
        }

        public void setWantedPosition(double x, double y, double z, double speed) {
            if (this.whiteTailedJackrabbitEntity.isInWater()) {
                speed = 1.5;
            }
            super.setWantedPosition(x, y, z, speed);
            if (speed > 0.0) {
                this.whiteTailedJackrabbitSpeed = speed;
            }
        }
    }

    static class EatBeetrootCropGoal
    extends MoveToBlockGoal {
        private final WhiteTailedJackrabbitEntity whiteTailedJackrabbitEntity;
        private boolean wantsBeetroots;
        private boolean hasTarget;

        public EatBeetrootCropGoal(WhiteTailedJackrabbitEntity rabbit) {
            super((PathfinderMob)rabbit, (double)0.7f, 16);
            this.whiteTailedJackrabbitEntity = rabbit;
        }

        public boolean canUse() {
            if (this.nextStartTick <= 0) {
                if (!ForgeEventFactory.getMobGriefingEvent((Level)this.whiteTailedJackrabbitEntity.level(), (Entity)this.whiteTailedJackrabbitEntity)) {
                    return false;
                }
                this.hasTarget = false;
                this.wantsBeetroots = this.whiteTailedJackrabbitEntity.wantsBeetroots();
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            return this.hasTarget && super.canContinueToUse();
        }

        public void tick() {
            super.tick();
            this.whiteTailedJackrabbitEntity.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, (double)(this.blockPos.getY() + 1), (double)this.blockPos.getZ() + 0.5, 10.0f, (float)this.whiteTailedJackrabbitEntity.getMaxHeadXRot());
            if (this.isReachedTarget()) {
                Level world = this.whiteTailedJackrabbitEntity.level();
                BlockPos blockPos = this.blockPos.above();
                BlockState blockState = world.getBlockState(blockPos);
                Block block = blockState.getBlock();
                if (this.hasTarget && block instanceof BeetrootBlock) {
                    int i = (Integer)blockState.getValue((Property)BeetrootBlock.AGE);
                    if (i == 0) {
                        world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 2);
                        world.destroyBlock(blockPos, true, (Entity)this.whiteTailedJackrabbitEntity);
                    } else {
                        world.setBlock(blockPos, (BlockState)blockState.setValue((Property)BeetrootBlock.AGE, (Comparable)Integer.valueOf(i - 1)), 2);
                        world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)this.whiteTailedJackrabbitEntity));
                        world.levelEvent(2001, blockPos, Block.getId((BlockState)blockState));
                    }
                    this.whiteTailedJackrabbitEntity.moreBeetrootTicks = 40;
                }
                this.hasTarget = false;
                this.nextStartTick = 10;
            }
        }

        protected boolean isValidTarget(LevelReader world, BlockPos pos) {
            BlockState blockState = world.getBlockState(pos);
            if (blockState.is(Blocks.FARMLAND) && this.wantsBeetroots && !this.hasTarget && (blockState = world.getBlockState(pos.above())).getBlock() instanceof BeetrootBlock && ((BeetrootBlock)blockState.getBlock()).isMaxAge(blockState)) {
                this.hasTarget = true;
                return true;
            }
            return false;
        }
    }

    static class EscapeDangerGoal
    extends PanicGoal {
        private final WhiteTailedJackrabbitEntity whiteTailedJackrabbitEntity;

        public EscapeDangerGoal(WhiteTailedJackrabbitEntity rabbit, double speed) {
            super((PathfinderMob)rabbit, speed);
            this.whiteTailedJackrabbitEntity = rabbit;
        }

        public void tick() {
            super.tick();
            this.whiteTailedJackrabbitEntity.setSpeed(this.speedModifier);
        }
    }
}

