/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom.ai.goal;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class EatHeldItemGoal
extends Goal {
    private final Animal animal;
    private final List<Item> items;

    public EatHeldItemGoal(Animal animal, Item ... items) {
        this.animal = animal;
        this.items = List.of(items);
    }

    public boolean canUse() {
        ItemStack heldItem = this.animal.getItemBySlot(EquipmentSlot.MAINHAND);
        return this.items.contains(heldItem.getItem());
    }

    public void start() {
        this.eatItem();
    }

    private void eatItem() {
        ItemStack heldItem = this.animal.getItemBySlot(EquipmentSlot.MAINHAND);
        this.animal.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
        heldItem.shrink(1);
        if (heldItem.isEmpty()) {
            this.animal.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    public boolean canContinueToUse() {
        return false;
    }
}

