/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom.ai.goal;

import java.util.List;
import net.alminoris.wildfields.entity.custom.MarmotEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PickUpItemGoal
extends Goal {
    private final PathfinderMob pathAwareEntity;
    private final double speed;
    private ItemEntity targetItem;
    private final List<Item> prioritizedItems;

    public PickUpItemGoal(PathfinderMob pathAwareEntity, double speed, Item ... pickupabbleItems) {
        this.pathAwareEntity = pathAwareEntity;
        this.speed = speed;
        this.prioritizedItems = List.of(pickupabbleItems);
    }

    public boolean canUse() {
        double searchRadius = 6.0;
        List nearbyItems = this.pathAwareEntity.level().getEntitiesOfClass(ItemEntity.class, this.pathAwareEntity.getBoundingBox().expandTowards(searchRadius, searchRadius, searchRadius), itemEntity -> this.prioritizedItems.contains(itemEntity.getItem().getItem()));
        if (!nearbyItems.isEmpty()) {
            this.targetItem = (ItemEntity)nearbyItems.getFirst();
            return true;
        }
        return false;
    }

    public void start() {
        if (this.targetItem != null) {
            this.pathAwareEntity.getNavigation().moveTo((Entity)this.targetItem, this.speed);
        }
    }

    public void tick() {
        if (this.targetItem != null && this.pathAwareEntity.distanceToSqr((Entity)this.targetItem) < 1.0) {
            ItemStack itemStack = this.targetItem.getItem();
            if (this.pathAwareEntity instanceof MarmotEntity) {
                ((MarmotEntity)this.pathAwareEntity).triggerPickUpAnimation();
            }
            this.pathAwareEntity.setItemSlot(EquipmentSlot.MAINHAND, itemStack.split(1));
            if (itemStack.isEmpty()) {
                this.targetItem.discard();
            }
            this.targetItem = null;
        }
    }

    public boolean canContinueToUse() {
        return this.targetItem != null && !this.targetItem.isRemoved();
    }
}

