/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom.projectile;

import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class SteppeArrowEntity
extends AbstractArrow {
    public SteppeArrowEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public SteppeArrowEntity(Level world, LivingEntity owner, ItemStack stack, @Nullable ItemStack shotFrom) {
        super((EntityType)ModEntities.STEPPE_ARROW.get(), owner, world, stack, shotFrom);
    }

    public SteppeArrowEntity(Level world, double x, double y, double z, ItemStack stack, @Nullable ItemStack shotFrom) {
        super((EntityType)ModEntities.STEPPE_ARROW.get(), x, y, z, world, stack, shotFrom);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && !this.inGround) {
            this.level().addParticle((ParticleOptions)ParticleTypes.INSTANT_EFFECT, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void onHit(HitResult result) {
        EntityHitResult entityHitResult;
        Entity hitEntity;
        super.onHit(result);
        if (result.getType() == HitResult.Type.ENTITY && (hitEntity = (entityHitResult = (EntityHitResult)result).getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)hitEntity;
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)entity;
                this.playSound((SoundEvent)ModSounds.SOUND_STEPPE_EAGLE_DEATH.get(), 1.5f, 1.0f);
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 3));
            }
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.STEPPE_ARROW.get());
    }
}

