/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.event;

import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.block.entity.ModBlockEntities;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.client.ModModelLayers;
import net.alminoris.wildfields.entity.custom.BisonEntity;
import net.alminoris.wildfields.entity.custom.BlackBilledMagpieEntity;
import net.alminoris.wildfields.entity.custom.CoyoteEntity;
import net.alminoris.wildfields.entity.custom.DarklingBeetleEntity;
import net.alminoris.wildfields.entity.custom.FerruginousHawkEntity;
import net.alminoris.wildfields.entity.custom.MarmotEntity;
import net.alminoris.wildfields.entity.custom.MoleEntity;
import net.alminoris.wildfields.entity.custom.PallidWingedGrasshopperEntity;
import net.alminoris.wildfields.entity.custom.SaigaEntity;
import net.alminoris.wildfields.entity.custom.ServalEntity;
import net.alminoris.wildfields.entity.custom.SteppeEagleEntity;
import net.alminoris.wildfields.entity.custom.SteppeViperEntity;
import net.alminoris.wildfields.entity.custom.WesternMeadowlarkEntity;
import net.alminoris.wildfields.entity.custom.WhiteTailedJackrabbitEntity;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.particle.LeavesParticle;
import net.alminoris.wildfields.particle.ModParticles;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wildfields", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModEventBusClientEvents {
    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (String name : ModBlockSetsHelper.WOOD_NAMES) {
            event.registerLayerDefinition(ModModelLayers.BOAT_LAYERS.get(name), BoatModel::createBodyModel);
            event.registerLayerDefinition(ModModelLayers.CHEST_BOAT_LAYERS.get(name), ChestBoatModel::createBodyModel);
        }
    }

    @SubscribeEvent
    public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.MOD_SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.MOD_HANGING_SIGN.get(), HangingSignRenderer::new);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.MARMOT.get(), MarmotEntity.setAttributes().build());
        event.put((EntityType)ModEntities.DARKLING_BEETLE.get(), DarklingBeetleEntity.setAttributes().build());
        event.put((EntityType)ModEntities.STEPPE_EAGLE.get(), SteppeEagleEntity.setAttributes().build());
        event.put((EntityType)ModEntities.STEPPE_VIPER.get(), SteppeViperEntity.setAttributes().build());
        event.put((EntityType)ModEntities.SAIGA.get(), SaigaEntity.setAttributes().build());
        event.put((EntityType)ModEntities.SERVAL.get(), ServalEntity.setAttributes().build());
        event.put((EntityType)ModEntities.COYOTE.get(), CoyoteEntity.setAttributes().build());
        event.put((EntityType)ModEntities.BISON.get(), BisonEntity.setAttributes().build());
        event.put((EntityType)ModEntities.FERRUGINOUS_HAWK.get(), FerruginousHawkEntity.setAttributes().build());
        event.put((EntityType)ModEntities.PALLID_WINGED_GRASSHOPPER.get(), PallidWingedGrasshopperEntity.setAttributes().build());
        event.put((EntityType)ModEntities.BLACK_BILLED_MAGPIE.get(), BlackBilledMagpieEntity.setAttributes().build());
        event.put((EntityType)ModEntities.WESTERN_MEADOWLARK.get(), WesternMeadowlarkEntity.setAttributes().build());
        event.put((EntityType)ModEntities.WHITE_TAILED_JACKRABBIT.get(), WhiteTailedJackrabbitEntity.setAttributes().build());
        event.put((EntityType)ModEntities.MOLE.get(), MoleEntity.setAttributes().build());
    }

    @SubscribeEvent
    public static void registerParticleProvider(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.OLIVE_LEAVES.get(), spriteSet -> (type, world, x, y, z, dx, dy, dz) -> new LeavesParticle(world, x, y, z, spriteSet, 12));
        event.registerSpriteSet((ParticleType)ModParticles.TREMBLING_ASPEN_LEAVES.get(), spriteSet -> (type, world, x, y, z, dx, dy, dz) -> new LeavesParticle(world, x, y, z, spriteSet, 12));
        event.registerSpriteSet((ParticleType)ModParticles.COTTONWOOD_LEAVES.get(), spriteSet -> (type, world, x, y, z, dx, dy, dz) -> new LeavesParticle(world, x, y, z, spriteSet, 12));
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)ModEntities.MARMOT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.DARKLING_BEETLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.STEPPE_EAGLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.STEPPE_VIPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SteppeViperEntity::isValidNaturalSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.SAIGA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SaigaEntity::isValidNaturalSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.SERVAL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.COYOTE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.FERRUGINOUS_HAWK.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.WHITE_TAILED_JACKRABBIT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WhiteTailedJackrabbitEntity::isValidNaturalSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.BISON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BisonEntity::isValidNaturalSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.PALLID_WINGED_GRASSHOPPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.BLACK_BILLED_MAGPIE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.WESTERN_MEADOWLARK.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.register((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)ModBlocks.TINY_GRASS.get()});
        blockColors.register((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)ModBlocks.BLUE_GRAMA_GRASS.get()});
        blockColors.register((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)ModBlockSetsHelper.LEAVES.get("cottonwood").get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.register((stack, tintIndex) -> GrassColor.get((double)0.5, (double)1.0), new ItemLike[]{((Block)ModBlocks.TINY_GRASS.get()).asItem()});
        itemColors.register((stack, tintIndex) -> GrassColor.get((double)0.5, (double)1.0), new ItemLike[]{((Block)ModBlocks.BLUE_GRAMA_GRASS.get()).asItem()});
        itemColors.register((stack, tintIndex) -> GrassColor.get((double)0.5, (double)1.0), new ItemLike[]{((Block)ModBlockSetsHelper.LEAVES.get("cottonwood").get()).asItem()});
        itemColors.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-6265536), new ItemLike[]{(ItemLike)ModItems.FURRED_LEATHER_HELMET.get(), (ItemLike)ModItems.FURRED_LEATHER_CHESTPLATE.get(), (ItemLike)ModItems.FURRED_LEATHER_LEGGINGS.get(), (ItemLike)ModItems.FURRED_LEATHER_BOOTS.get()});
    }
}

