/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.event;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.alminoris.wildfields.item.ModItems;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wildfields")
public class PrairieTalismanHandler {
    private static final Map<UUID, Vec3> LAST_POS = new ConcurrentHashMap<UUID, Vec3>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerLevel level : event.getServer().getAllLevels()) {
            for (ServerPlayer player : level.players()) {
                Vec3 currPos = player.position();
                Vec3 prevPos = LAST_POS.get(player.getUUID());
                if (prevPos == null) {
                    LAST_POS.put(player.getUUID(), currPos);
                    continue;
                }
                double dx = currPos.x - prevPos.x;
                double dy = currPos.y - prevPos.y;
                double dz = currPos.z - prevPos.z;
                double horizSq = dx * dx + dz * dz;
                boolean isMoving = horizSq > 1.0E-6;
                boolean isSprinting = player.isSprinting();
                boolean isFalling = !player.onGround() && dy < -0.08;
                ItemStack talismanStack = ItemStack.EMPTY;
                int talismanSlot = -1;
                for (int i = 0; i < player.getInventory().items.size(); ++i) {
                    ItemStack stack = (ItemStack)player.getInventory().items.get(i);
                    if (!stack.is((Item)ModItems.PRAIRIES_TALISMAN.get())) continue;
                    talismanStack = stack;
                    talismanSlot = i;
                    break;
                }
                if (!talismanStack.isEmpty() && talismanStack.getDamageValue() < talismanStack.getMaxDamage()) {
                    Biome biome = (Biome)level.getBiome(player.blockPosition()).value();
                    ResourceLocation biomeId = level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome);
                    if (biomeId != null && biomeId.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)"prairies_biome"))) {
                        player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 40, 0, true, false, false));
                        player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 40, 0, true, false, false));
                        int damage = 0;
                        if (isFalling) {
                            damage = 10;
                        } else if (isSprinting) {
                            damage = 5;
                        } else if (isMoving) {
                            damage = 2;
                        }
                        if (damage > 0 && player.level().getGameTime() % 20L == 0L) {
                            talismanStack.hurtAndBreak(damage, (LivingEntity)player, EquipmentSlot.MAINHAND);
                            if (talismanStack.getDamageValue() >= talismanStack.getMaxDamage()) {
                                player.getInventory().removeItemNoUpdate(talismanSlot);
                            }
                        }
                    }
                }
                LAST_POS.put(player.getUUID(), currPos);
            }
        }
    }
}

