/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.item;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.alminoris.wildfields.item.ModItems;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ModArmorMaterials {
    public static final Holder<ArmorMaterial> DARKLING_BEETLE_SHELL = ModArmorMaterials.register("darkling_beetle_shell", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 4);
        attribute.put(ArmorItem.Type.LEGGINGS, 8);
        attribute.put(ArmorItem.Type.CHESTPLATE, 12);
        attribute.put(ArmorItem.Type.HELMET, 4);
        attribute.put(ArmorItem.Type.BODY, 8);
    }), 10, 2.0f, 0.5f, ModItems.DARKLING_BEETLE_SHELL, null);
    public static final Holder<ArmorMaterial> FURRED_LEATHER = ModArmorMaterials.register("furred_leather", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 1);
        attribute.put(ArmorItem.Type.LEGGINGS, 3);
        attribute.put(ArmorItem.Type.CHESTPLATE, 4);
        attribute.put(ArmorItem.Type.HELMET, 2);
        attribute.put(ArmorItem.Type.BODY, 4);
    }), 20, 0.0f, 0.0f, ModItems.MARMOT_FUR, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)"furred_leather"), "", true), new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)"furred_leather"), "_overlay", false)));

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> typeProtection, int enchantability, float toughness, float knockbackResistance, Supplier<Item> ingredientItem, List<ArmorMaterial.Layer> layers) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)name);
        Holder equipSound = SoundEvents.ARMOR_EQUIP_NETHERITE;
        Supplier<Ingredient> ingredient = () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingredientItem.get()});
        if (layers == null) {
            layers = List.of(new ArmorMaterial.Layer(location));
        }
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, typeProtection.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)location, (Object)new ArmorMaterial(typeProtection, enchantability, equipSound, ingredient, layers, toughness, knockbackResistance));
    }
}

