/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.item.custom;

import java.util.Collections;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class EarthwormItem
extends Item {
    private static final Map<Block, IntegerProperty> ALLOWED_PLANTS = Map.of(Blocks.WHEAT, BlockStateProperties.AGE_7, Blocks.BEETROOTS, BlockStateProperties.AGE_3, Blocks.CARROTS, BlockStateProperties.AGE_7, Blocks.POTATOES, BlockStateProperties.AGE_7);

    public EarthwormItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        int maxAge;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (!ALLOWED_PLANTS.containsKey(block)) {
            return InteractionResult.PASS;
        }
        IntegerProperty ageProperty = ALLOWED_PLANTS.get(block);
        if (!state.hasProperty((Property)ageProperty)) {
            return InteractionResult.PASS;
        }
        int age = (Integer)state.getValue((Property)ageProperty);
        if (age < (maxAge = ((Integer)Collections.max(ageProperty.getPossibleValues())).intValue()) && level.random.nextFloat() < 0.5f) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ageProperty, (Comparable)Integer.valueOf(age + 1)), 2);
            if (player != null && !player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.ROOTED_DIRT_PLACE, SoundSource.BLOCKS, 0.5f, 1.2f);
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.7, (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }
}

