/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class LeavesParticle
extends TextureSheetParticle {
    private float angleSpeed;
    private final float randomAngle;
    private final float drift;

    public LeavesParticle(ClientLevel world, double x, double y, double z, SpriteSet spriteSet, int j) {
        super(world, x, y, z);
        float f;
        this.setSprite(spriteSet.get(this.random.nextInt(j), j));
        this.angleSpeed = (float)Math.toRadians(this.random.nextBoolean() ? -30.0 : 30.0);
        this.randomAngle = this.random.nextFloat();
        this.drift = (float)Math.toRadians(this.random.nextBoolean() ? -5.0 : 5.0);
        this.lifetime = 200;
        this.gravity = 8.0E-4f;
        this.quadSize = f = this.random.nextBoolean() ? 0.1f : 0.1125f;
        this.setSize(f, f);
        this.friction = 1.0f;
        this.setColor(100.0f, 29.8f, 71.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
            return;
        }
        if (!this.removed) {
            float f = 200 - this.lifetime;
            float g = Math.min(f / 200.0f, 1.0f);
            double d = Math.cos(Math.toRadians(this.randomAngle * 60.0f)) * 2.0 * Math.pow(g, 1.25);
            double e = Math.sin(Math.toRadians(this.randomAngle * 60.0f)) * 2.0 * Math.pow(g, 1.25);
            this.xd += d * (double)7.5E-4f;
            this.zd += e * (double)7.5E-4f;
            this.yd -= (double)this.gravity;
            this.angleSpeed += this.drift / 20.0f;
            this.oRoll = this.roll;
            this.roll += this.angleSpeed / 20.0f;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround || this.lifetime < 199 && (this.xd == 0.0 || this.zd == 0.0)) {
                this.remove();
            }
            if (!this.removed) {
                this.xd *= (double)this.friction;
                this.yd *= (double)this.friction;
                this.zd *= (double)this.friction;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }
}

