/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.util.helper;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.world.tree.ModTreeGrowers;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockSetsHelper {
    public static final String[] WOOD_NAMES = new String[]{"olive", "tamarisk", "western_serviceberry", "trembling_aspen", "cottonwood"};
    public static final String[] STONE_NAMES = new String[]{"dolomite", "saltmarsh", "loessic_marl", "loamy_marl", "fossil_marlstone", "limestone"};
    public static final String[] STONE_TYPES = new String[]{"block", "cobbled", "polished", "bricks", "chiseled"};
    public static final String[] BUSHES_NAMES = new String[]{"western_snowberry", "prickly_pear"};
    public static final Dictionary<String, RegistryObject<Block>> BUSHES = new Hashtable<String, RegistryObject<Block>>();
    public static final Dictionary<String, RegistryObject<Item>> BERRIES = new Hashtable<String, RegistryObject<Item>>();
    public static final String[] CROP_NAMES = new String[]{"oat", "barley"};
    public static final String[] WILD_CROP_NAMES = new String[]{"wheat", "oat", "barley"};
    public static final Dictionary<String, RegistryObject<Block>> WILD_CROPS = new Hashtable<String, RegistryObject<Block>>();
    public static final Dictionary<String, RegistryObject<Block>> HAY_BLOCKS = new Hashtable<String, RegistryObject<Block>>();
    public static final Dictionary<String, RegistryObject<Block>> CROPS = new Hashtable<String, RegistryObject<Block>>();
    public static final Dictionary<String, RegistryObject<Item>> CROP_ITEMS = new Hashtable<String, RegistryObject<Item>>();
    public static final Dictionary<String, RegistryObject<Item>> CROP_SEEDS = new Hashtable<String, RegistryObject<Item>>();
    public static final Map<String, WoodType> WOOD_TYPES;
    public static final Map<String, RegistryObject<Block>> LEAVES;
    public static final Map<String, RegistryObject<Block>> LOGS;
    public static final Map<String, RegistryObject<Block>> WOODS;
    public static final Map<String, RegistryObject<Block>> STRIPPED_LOGS;
    public static final Map<String, RegistryObject<Block>> STRIPPED_WOODS;
    public static final Map<String, RegistryObject<Block>> WOODEN_PLANKS;
    public static final Map<String, RegistryObject<Block>> WOODEN_SLABS;
    public static final Map<String, RegistryObject<Block>> WOODEN_STAIRS;
    public static final Map<String, RegistryObject<Block>> WOODEN_FENCES;
    public static final Map<String, RegistryObject<Block>> WOODEN_FENCE_GATES;
    public static final Map<String, RegistryObject<Block>> WOODEN_DOORS;
    public static final Map<String, RegistryObject<Block>> WOODEN_TRAPDOORS;
    public static final Map<String, RegistryObject<Block>> WOODEN_BUTTONS;
    public static final Map<String, RegistryObject<Block>> WOODEN_PRESSURE_PLATES;
    public static final Map<String, RegistryObject<Block>> WOODEN_SIGNS;
    public static final Map<String, RegistryObject<Block>> WOODEN_WALL_SIGNS;
    public static final Map<String, RegistryObject<Block>> WOODEN_HANGING_SIGNS;
    public static final Map<String, RegistryObject<Block>> WOODEN_WALL_HANGING_SIGNS;
    public static final Map<String, RegistryObject<Item>> WOODEN_SIGN_ITEMS;
    public static final Map<String, RegistryObject<Item>> WOODEN_HANGING_SIGN_ITEMS;
    public static final Map<String, RegistryObject<Block>> WOODEN_SAPLINGS;
    public static final Map<String, RegistryObject<Item>> WOODEN_BOATS;
    public static final Map<String, RegistryObject<Item>> WOODEN_CHEST_BOATS;
    public static final Map<String, Map<String, RegistryObject<Block>>> STONE_BLOCKS;
    public static final Map<String, Map<String, RegistryObject<Block>>> STONE_SLABS;
    public static final Map<String, Map<String, RegistryObject<Block>>> STONE_STAIRS;
    public static final Map<String, Map<String, RegistryObject<Block>>> STONE_WALLS;

    static {
        for (String name : BUSHES_NAMES) {
            BUSHES.put(name, ModBlocks.registerBushBlock(name + (name.equals("prickly_pear") ? "_cactus" : "")));
            BERRIES.put(name, ModItems.registerBerryItem(name, 2, 0.4f, BUSHES.get(name)));
        }
        for (String name : WILD_CROP_NAMES) {
            WILD_CROPS.put(name, ModBlocks.registerWildCropBlock(name));
        }
        for (String name : CROP_NAMES) {
            CROP_ITEMS.put(name, ModItems.registerCropItem(name));
            HAY_BLOCKS.put(name, ModBlocks.registerHayBlock(name));
            CROPS.put(name, ModBlocks.registerCropBlock(name));
            CROP_SEEDS.put(name, ModItems.registerSeedsItem(name, CROPS.get(name)));
        }
        WOOD_TYPES = new HashMap<String, WoodType>();
        LEAVES = new HashMap<String, RegistryObject<Block>>();
        LOGS = new HashMap<String, RegistryObject<Block>>();
        WOODS = new HashMap<String, RegistryObject<Block>>();
        STRIPPED_LOGS = new HashMap<String, RegistryObject<Block>>();
        STRIPPED_WOODS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_PLANKS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_SLABS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_STAIRS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_FENCES = new HashMap<String, RegistryObject<Block>>();
        WOODEN_FENCE_GATES = new HashMap<String, RegistryObject<Block>>();
        WOODEN_DOORS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_TRAPDOORS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_BUTTONS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_PRESSURE_PLATES = new HashMap<String, RegistryObject<Block>>();
        WOODEN_SIGNS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_WALL_SIGNS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_HANGING_SIGNS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_WALL_HANGING_SIGNS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_SIGN_ITEMS = new HashMap<String, RegistryObject<Item>>();
        WOODEN_HANGING_SIGN_ITEMS = new HashMap<String, RegistryObject<Item>>();
        WOODEN_SAPLINGS = new HashMap<String, RegistryObject<Block>>();
        WOODEN_BOATS = new HashMap<String, RegistryObject<Item>>();
        WOODEN_CHEST_BOATS = new HashMap<String, RegistryObject<Item>>();
        STONE_BLOCKS = new HashMap<String, Map<String, RegistryObject<Block>>>();
        STONE_SLABS = new HashMap<String, Map<String, RegistryObject<Block>>>();
        STONE_STAIRS = new HashMap<String, Map<String, RegistryObject<Block>>>();
        STONE_WALLS = new HashMap<String, Map<String, RegistryObject<Block>>>();
        for (String name : WOOD_NAMES) {
            WOOD_TYPES.put(name, WoodType.register((WoodType)new WoodType("wildfields:" + name, BlockSetType.OAK)));
            LEAVES.put(name, ModBlocks.registerLeavesBlock(name));
            LOGS.put(name, ModBlocks.registerLogsBlock(name));
            WOODS.put(name, ModBlocks.registerWoodsBlock(name));
            STRIPPED_LOGS.put(name, ModBlocks.registerStrippedLogsBlock(name));
            STRIPPED_WOODS.put(name, ModBlocks.registerStrippedWoodsBlock(name));
            WOODEN_PLANKS.put(name, ModBlocks.registerPlanksBlock(name));
            WOODEN_SLABS.put(name, ModBlocks.registerSlabBlock(name));
            WOODEN_STAIRS.put(name, ModBlocks.registerStairsBlock(name, WOODEN_PLANKS.get(name)));
            WOODEN_FENCES.put(name, ModBlocks.registerFenceBlock(name));
            WOODEN_FENCE_GATES.put(name, ModBlocks.registerFenceGateBlock(name));
            WOODEN_DOORS.put(name, ModBlocks.registerDoorBlock(name));
            WOODEN_TRAPDOORS.put(name, ModBlocks.registerTrapdoorBlock(name));
            WOODEN_BUTTONS.put(name, ModBlocks.registerButtonBlock(name));
            WOODEN_PRESSURE_PLATES.put(name, ModBlocks.registerPressurePlateBlock(name));
            WOODEN_SIGNS.put(name, ModBlocks.registerSignBlock(name));
            WOODEN_WALL_SIGNS.put(name, ModBlocks.registerWallSignBlock(name));
            WOODEN_HANGING_SIGNS.put(name, ModBlocks.registerHangingSignBlock(name));
            WOODEN_WALL_HANGING_SIGNS.put(name, ModBlocks.registerWallHangingSignBlock(name));
            WOODEN_SAPLINGS.put(name, ModBlocks.registerSaplingBlock(name, ModTreeGrowers.saplingGenerators.get(name)));
        }
        for (String name : STONE_NAMES) {
            HashMap<String, RegistryObject<Block>> typeMap1 = new HashMap<String, RegistryObject<Block>>();
            HashMap<String, RegistryObject<Block>> typeMap2 = new HashMap<String, RegistryObject<Block>>();
            HashMap<String, RegistryObject<Block>> typeMap3 = new HashMap<String, RegistryObject<Block>>();
            HashMap<String, RegistryObject<Block>> typeMap4 = new HashMap<String, RegistryObject<Block>>();
            for (String type : STONE_TYPES) {
                typeMap1.put(type, ModBlocks.registerStoneBlock(name, type));
                typeMap2.put(type, ModBlocks.registerStoneSlab(name, type));
                typeMap3.put(type, ModBlocks.registerStoneStairs(name, type));
                typeMap4.put(type, ModBlocks.registerStoneWall(name, type));
            }
            STONE_BLOCKS.put(name, typeMap1);
            STONE_SLABS.put(name, typeMap2);
            STONE_STAIRS.put(name, typeMap3);
            STONE_WALLS.put(name, typeMap4);
        }
    }
}

