/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.world;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.block.custom.BerryBushBlock;
import net.alminoris.wildfields.block.custom.CottonwoodFluffBlock;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.alminoris.wildfields.world.gen.decorator.custom.CustomVineLogDecorator;
import net.alminoris.wildfields.world.gen.feature.custom.TripleTallPlantConfig;
import net.alminoris.wildfields.world.gen.features.ModFeatures;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BushFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.BendingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.GiantTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static ResourceKey<ConfiguredFeature<?, ?>> OLIVE_KEY = ModConfiguredFeatures.registerKey("olive");
    public static ResourceKey<ConfiguredFeature<?, ?>> TAMARISK_KEY = ModConfiguredFeatures.registerKey("tamarisk");
    public static ResourceKey<ConfiguredFeature<?, ?>> WESTERN_SERVICEBERRY_KEY = ModConfiguredFeatures.registerKey("western_serviceberry");
    public static ResourceKey<ConfiguredFeature<?, ?>> TREMBLING_ASPEN_KEY = ModConfiguredFeatures.registerKey("trembling_aspen");
    public static ResourceKey<ConfiguredFeature<?, ?>> COTTONWOOD_KEY = ModConfiguredFeatures.registerKey("cottonwood");
    public static ResourceKey<ConfiguredFeature<?, ?>> GROUP_TREMBLING_ASPEN_KEY = ModConfiguredFeatures.registerKey("group_trembling_aspen");
    public static ResourceKey<ConfiguredFeature<?, ?>> GROUP_COTTONWOOD_KEY = ModConfiguredFeatures.registerKey("group_cottonwood");
    public static ResourceKey<ConfiguredFeature<?, ?>> STEPPES_GRASS_KEY = ModConfiguredFeatures.registerKey("steppes_grass");
    public static ResourceKey<ConfiguredFeature<?, ?>> STEPPES_GRASS_1_KEY = ModConfiguredFeatures.registerKey("steppes_grass_1");
    public static ResourceKey<ConfiguredFeature<?, ?>> STEPPES_GRASS_2_KEY = ModConfiguredFeatures.registerKey("steppes_grass_2");
    public static ResourceKey<ConfiguredFeature<?, ?>> PRAIRIES_GRASS_KEY = ModConfiguredFeatures.registerKey("prairies_grass");
    public static ResourceKey<ConfiguredFeature<?, ?>> PRAIRIES_GRASS_1_KEY = ModConfiguredFeatures.registerKey("prairies_grass_1");
    public static ResourceKey<ConfiguredFeature<?, ?>> PRAIRIES_GRASS_2_KEY = ModConfiguredFeatures.registerKey("prairies_grass_2");
    public static ResourceKey<ConfiguredFeature<?, ?>> THYME_KEY = ModConfiguredFeatures.registerKey("thyme");
    public static ResourceKey<ConfiguredFeature<?, ?>> PRICKLY_PEAR_CACTUS_KEY = ModConfiguredFeatures.registerKey("prickly_pear_cactus");
    public static ResourceKey<ConfiguredFeature<?, ?>> WESTERN_SNOWBERRY_KEY = ModConfiguredFeatures.registerKey("western_snowberry");
    public static ResourceKey<ConfiguredFeature<?, ?>> SPIDER_MILKWEED_KEY = ModConfiguredFeatures.registerKey("spider_milkweed");
    public static ResourceKey<ConfiguredFeature<?, ?>> WORMWOOD_KEY = ModConfiguredFeatures.registerKey("wormwood");
    public static ResourceKey<ConfiguredFeature<?, ?>> SALTMARSH_WATER_KEY = ModConfiguredFeatures.registerKey("saltmarsh_water");
    public static ResourceKey<ConfiguredFeature<?, ?>> SAND_WATER_KEY = ModConfiguredFeatures.registerKey("sand_water");
    public static ResourceKey<ConfiguredFeature<?, ?>> SAND_1_WATER_KEY = ModConfiguredFeatures.registerKey("sand_1_water");
    public static ResourceKey<ConfiguredFeature<?, ?>> DOLOMITE_KEY = ModConfiguredFeatures.registerKey("dolomite");
    public static ResourceKey<ConfiguredFeature<?, ?>> MARL_KEY = ModConfiguredFeatures.registerKey("marl");
    public static ResourceKey<ConfiguredFeature<?, ?>> LOESSIC_MARL_KEY = ModConfiguredFeatures.registerKey("loessic_marl");
    public static ResourceKey<ConfiguredFeature<?, ?>> LIMESTONE_KEY = ModConfiguredFeatures.registerKey("limestone");
    public static ResourceKey<ConfiguredFeature<?, ?>> VIOLA_KEY = ModConfiguredFeatures.registerKey("viola");
    public static ResourceKey<ConfiguredFeature<?, ?>> PRAIRIE_SAGE_KEY = ModConfiguredFeatures.registerKey("prairie_sage");
    public static ResourceKey<ConfiguredFeature<?, ?>> PRAIRIES_FLOWERS_1_KEY = ModConfiguredFeatures.registerKey("prairies_flowers_1");
    public static ResourceKey<ConfiguredFeature<?, ?>> PRAIRIES_FLOWERS_2_KEY = ModConfiguredFeatures.registerKey("prairies_flowers_2");
    public static ResourceKey<ConfiguredFeature<?, ?>> WILD_WHEAT_KEY = ModConfiguredFeatures.registerKey("wild_wheat");
    public static ResourceKey<ConfiguredFeature<?, ?>> WILD_BARLEY_KEY = ModConfiguredFeatures.registerKey("wild_barley");
    public static ResourceKey<ConfiguredFeature<?, ?>> WILD_OAT_KEY = ModConfiguredFeatures.registerKey("wild_oat");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> overworldMarls = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlockSetsHelper.STONE_BLOCKS.get("loamy_marl").get("block").get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlockSetsHelper.STONE_BLOCKS.get("fossil_marlstone").get("block").get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldLoessicMarls = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlockSetsHelper.STONE_BLOCKS.get("loessic_marl").get("block").get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldLimestone = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlockSetsHelper.STONE_BLOCKS.get("limestone").get("block").get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, MARL_KEY, Feature.ORE, new OreConfiguration(overworldMarls, 64));
        ModConfiguredFeatures.register(context, LOESSIC_MARL_KEY, Feature.ORE, new OreConfiguration(overworldLoessicMarls, 48));
        ModConfiguredFeatures.register(context, LIMESTONE_KEY, Feature.ORE, new OreConfiguration(overworldLimestone, 48));
        ModConfiguredFeatures.register(context, OLIVE_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LOGS.get("olive").get())), (TrunkPlacer)new BendingTrunkPlacer(4, 2, 1, 5, (IntProvider)ConstantInt.of((int)2)), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LEAVES.get("olive").get())), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build());
        ModConfiguredFeatures.register(context, TAMARISK_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LOGS.get("tamarisk").get())), (TrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LEAVES.get("tamarisk").get())), (FoliagePlacer)new BushFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)1), 2), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build());
        ModConfiguredFeatures.register(context, WESTERN_SERVICEBERRY_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LOGS.get("western_serviceberry").get())), (TrunkPlacer)new ForkingTrunkPlacer(2, 0, 1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LEAVES.get("western_serviceberry").get())), (FoliagePlacer)new BushFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.of((int)2), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).decorators(List.of(new CustomVineLogDecorator(0.85f, (Block)ModBlocks.GREEN_LICHEN.get()))).build());
        ModConfiguredFeatures.register(context, COTTONWOOD_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LOGS.get("cottonwood").get())), (TrunkPlacer)new GiantTrunkPlacer(6, 3, 1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LEAVES.get("cottonwood").get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).decorators((List)ImmutableList.of((Object)new AttachedToLeavesDecorator(0.35f, 1, 0, (BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)ModBlocks.COTTONWOOD_FLUFF.get()).defaultBlockState()), CottonwoodFluffBlock.AGE, (IntProvider)UniformInt.of((int)0, (int)4)), 2, List.of(Direction.DOWN)))).ignoreVines().build());
        ModConfiguredFeatures.register(context, TREMBLING_ASPEN_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LOGS.get("trembling_aspen").get())), (TrunkPlacer)new StraightTrunkPlacer(10, 2, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LEAVES.get("trembling_aspen").get())), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)5), 100), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build());
        ModConfiguredFeatures.register(context, GROUP_COTTONWOOD_KEY, (Feature)ModFeatures.TREE_GROUP.get(), new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LOGS.get("cottonwood").get())), (TrunkPlacer)new GiantTrunkPlacer(6, 3, 1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LEAVES.get("cottonwood").get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).decorators((List)ImmutableList.of((Object)new AttachedToLeavesDecorator(0.35f, 1, 0, (BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)ModBlocks.COTTONWOOD_FLUFF.get()).defaultBlockState()), CottonwoodFluffBlock.AGE, (IntProvider)UniformInt.of((int)0, (int)4)), 2, List.of(Direction.DOWN)))).ignoreVines().build());
        ModConfiguredFeatures.register(context, GROUP_TREMBLING_ASPEN_KEY, (Feature)ModFeatures.TREE_GROUP.get(), new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LOGS.get("trembling_aspen").get())), (TrunkPlacer)new StraightTrunkPlacer(10, 2, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.LEAVES.get("trembling_aspen").get())), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)5), 100), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build());
        ModConfiguredFeatures.register(context, STEPPES_GRASS_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.FEATHER_GRASS.get()))), List.of(Blocks.GRASS_BLOCK), (int)4096));
        ModConfiguredFeatures.register(context, STEPPES_GRASS_1_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.TINY_GRASS.get()))), List.of(Blocks.GRASS_BLOCK), (int)1024));
        ModConfiguredFeatures.register(context, STEPPES_GRASS_2_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SHORT_GRASS)), List.of(Blocks.GRASS_BLOCK), (int)1024));
        FeatureUtils.register(context, PRAIRIE_SAGE_KEY, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)((Feature)ModFeatures.TRIPLE_TALL_PLANT.get()), (FeatureConfiguration)new TripleTallPlantConfig((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.PRAIRIE_SAGE.get()))), List.of(Blocks.GRASS_BLOCK), (int)1024));
        ModConfiguredFeatures.register(context, PRAIRIES_FLOWERS_1_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)ModBlocks.PRAIRIE_ROSE.get()).defaultBlockState(), 35).add((Object)Blocks.AZURE_BLUET.defaultBlockState(), 15))), List.of(Blocks.GRASS_BLOCK), (int)4096));
        ModConfiguredFeatures.register(context, PRAIRIES_FLOWERS_2_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)ModBlocks.SMOOTH_ASTER.get()).defaultBlockState(), 35).add((Object)Blocks.ALLIUM.defaultBlockState(), 15))), List.of(Blocks.GRASS_BLOCK), (int)4096));
        ModConfiguredFeatures.register(context, PRAIRIES_GRASS_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SHORT_GRASS)), List.of(Blocks.GRASS_BLOCK), (int)8024));
        ModConfiguredFeatures.register(context, PRAIRIES_GRASS_1_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.BLUE_GRAMA_GRASS.get()))), List.of(Blocks.GRASS_BLOCK), (int)4096));
        ModConfiguredFeatures.register(context, PRAIRIES_GRASS_2_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.TALL_GRASS)), List.of(Blocks.GRASS_BLOCK), (int)1024));
        ModConfiguredFeatures.register(context, WILD_WHEAT_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.WILD_CROPS.get("wheat").get()))), List.of(Blocks.GRASS_BLOCK), (int)12024));
        ModConfiguredFeatures.register(context, WILD_BARLEY_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.WILD_CROPS.get("barley").get()))), List.of(Blocks.GRASS_BLOCK), (int)12024));
        ModConfiguredFeatures.register(context, WILD_OAT_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlockSetsHelper.WILD_CROPS.get("oat").get()))), List.of(Blocks.GRASS_BLOCK), (int)12024));
        ModConfiguredFeatures.register(context, SALTMARSH_WATER_KEY, Feature.ORE, new OreConfiguration(List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.GRASS_BLOCK), (BlockState)((Block)ModBlockSetsHelper.STONE_BLOCKS.get("saltmarsh").get("block").get()).defaultBlockState()), OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.DIRT), (BlockState)((Block)ModBlockSetsHelper.STONE_BLOCKS.get("saltmarsh").get("block").get()).defaultBlockState())), 39));
        ModConfiguredFeatures.register(context, SAND_WATER_KEY, Feature.ORE, new OreConfiguration(List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.GRASS_BLOCK), (BlockState)Blocks.SAND.defaultBlockState()), OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.DIRT), (BlockState)Blocks.SAND.defaultBlockState())), 39));
        ModConfiguredFeatures.register(context, SAND_1_WATER_KEY, Feature.ORE, new OreConfiguration(List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.GRASS_BLOCK), (BlockState)Blocks.SAND.defaultBlockState()), OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.DIRT), (BlockState)Blocks.SAND.defaultBlockState())), 64));
        ModConfiguredFeatures.register(context, THYME_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.THYME.get()))), List.of(Blocks.GRASS_BLOCK)));
        ModConfiguredFeatures.register(context, WESTERN_SNOWBERRY_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlockSetsHelper.BUSHES.get("western_snowberry").get()).defaultBlockState().setValue((Property)BerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK)));
        FeatureUtils.register(context, PRICKLY_PEAR_CACTUS_KEY, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlockSetsHelper.BUSHES.get("prickly_pear").get()).defaultBlockState().setValue((Property)BerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.SAND)));
        FeatureUtils.register(context, SPIDER_MILKWEED_KEY, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.SPIDER_MILKWEED.get()))), List.of(Blocks.GRASS_BLOCK)));
        ModConfiguredFeatures.register(context, WORMWOOD_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.WORMWOOD.get()))), List.of(Blocks.GRASS_BLOCK)));
        ModConfiguredFeatures.register(context, DOLOMITE_KEY, Feature.FOREST_ROCK, new BlockStateConfiguration(((Block)ModBlockSetsHelper.STONE_BLOCKS.get("dolomite").get("block").get()).defaultBlockState()));
        SimpleWeightedRandomList.Builder violaBuilder = SimpleWeightedRandomList.builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                violaBuilder.add((Object)((BlockState)((BlockState)((Block)ModBlocks.VIOLA.get()).defaultBlockState().setValue((Property)PinkPetalsBlock.AMOUNT, (Comparable)Integer.valueOf(i))).setValue((Property)PinkPetalsBlock.FACING, (Comparable)dir)), 1);
            }
        }
        ModConfiguredFeatures.register(context, VIOLA_KEY, Feature.RANDOM_PATCH, new RandomPatchConfiguration(2, 1, 1, PlacementUtils.inlinePlaced((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(violaBuilder)), (PlacementModifier[])new PlacementModifier[0])));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

