/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.world.biome;

import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.world.ModPlacedFeatures;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class ModBiomes {
    public static final ResourceKey<Biome> STEPPES = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)"steppes_biome"));
    public static final ResourceKey<Biome> PRAIRIES = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)"prairies_biome"));
    public static final ResourceKey<Biome> PAMPASAS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)"pampasas_biome"));

    public static void bootstrap(BootstrapContext<Biome> context) {
        context.register(STEPPES, (Object)ModBiomes.steppesBiome(context));
        context.register(PRAIRIES, (Object)ModBiomes.prairiesBiome(context));
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)builder);
    }

    private static Biome steppesBiome(BootstrapContext<Biome> context) {
        BiomeGenerationSettings.Builder generationBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.MARMOT.get(), 5, 6, 10));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SAIGA.get(), 7, 4, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SERVAL.get(), 7, 1, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.DARKLING_BEETLE.get(), 8, 1, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.STEPPE_VIPER.get(), 15, 1, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.STEPPE_EAGLE.get(), 10, 1, 1));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 6, 2, 5));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 4, 4, 4));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
        ModBiomes.globalOverworldGeneration(generationBuilder);
        generationBuilder.addFeature(GenerationStep.Decoration.FLUID_SPRINGS, MiscOverworldPlacements.SPRING_WATER);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.DOLOMITE_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.SALTMARSH_WATER_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.SAND_WATER_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.OLIVE_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.TAMARISK_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.STEPPES_GRASS_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.WILD_WHEAT_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.WILD_BARLEY_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.STEPPES_GRASS_1_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.STEPPES_GRASS_2_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.THYME_PLACED_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.1f).temperature(0.7f).generationSettings(generationBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(10538712).waterFogColor(4814207).skyColor(11066100).grassColorOverride(14996322).foliageColorOverride(11117614).fogColor(15067323).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).build();
    }

    private static Biome prairiesBiome(BootstrapContext<Biome> context) {
        BiomeGenerationSettings.Builder generationBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BISON.get(), 150, 6, 12));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WESTERN_MEADOWLARK.get(), 95, 2, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.COYOTE.get(), 100, 1, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.FERRUGINOUS_HAWK.get(), 80, 1, 1));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.PALLID_WINGED_GRASSHOPPER.get(), 60, 2, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WHITE_TAILED_JACKRABBIT.get(), 130, 2, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BLACK_BILLED_MAGPIE.get(), 95, 2, 3));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
        ModBiomes.globalOverworldGeneration(generationBuilder);
        generationBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.LIMESTONE_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.FLUID_SPRINGS, MiscOverworldPlacements.SPRING_WATER);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.SAND_1_WATER_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.COTTONWOOD_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PRAIRIES_GRASS_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.WILD_OAT_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PRAIRIES_GRASS_1_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PRAIRIES_GRASS_2_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PRAIRIE_SAGE_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PRAIRIES_FLOWERS_1_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PRAIRIES_FLOWERS_2_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PRICKLY_PEAR_CACTUS_PLACED_KEY);
        generationBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.WESTERN_SNOWBERRY_PLACED_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.5f).temperature(0.75f).generationSettings(generationBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4632992).waterFogColor(2782822).skyColor(8835043).grassColorOverride(10406764).foliageColorOverride(8364877).fogColor(14674132).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).build();
    }

    private static Biome pampasasBiome(BootstrapContext<Biome> context) {
        BiomeGenerationSettings.Builder generationBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
        ModBiomes.globalOverworldGeneration(generationBuilder);
        generationBuilder.addFeature(GenerationStep.Decoration.FLUID_SPRINGS, MiscOverworldPlacements.SPRING_WATER);
        return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.6f).temperature(0.75f).generationSettings(generationBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(9165524).waterFogColor(5349531).skyColor(9762286).grassColorOverride(14806661).foliageColorOverride(4033597).fogColor(15854304).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).build();
    }
}

