/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.world.gen.decorator.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.alminoris.wildfields.world.gen.decorator.ModTreeDecorators;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomVineLogDecorator
extends TreeDecorator {
    public static final MapCodec<CustomVineLogDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)ForgeRegistries.BLOCKS.getCodec().fieldOf("block").forGetter(decorator -> decorator.block)).apply((Applicative)instance, CustomVineLogDecorator::new));
    private final float probability;
    private final Block block;

    public CustomVineLogDecorator(float probability, Block block) {
        this.probability = probability;
        this.block = block;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)ModTreeDecorators.CUSTOM_VINE_LOG_DECORATOR.get();
    }

    public void place(TreeDecorator.Context generator) {
        RandomSource random = generator.random();
        generator.logs().forEach(pos -> {
            BlockPos blockPos;
            if (random.nextFloat() < this.probability && generator.isAir(blockPos = pos.west())) {
                this.placeVines(blockPos, VineBlock.EAST, generator);
            }
            if (random.nextFloat() < this.probability && generator.isAir(blockPos = pos.east())) {
                this.placeVines(blockPos, VineBlock.WEST, generator);
            }
            if (random.nextFloat() < this.probability && generator.isAir(blockPos = pos.north())) {
                this.placeVines(blockPos, VineBlock.SOUTH, generator);
            }
            if (random.nextFloat() < this.probability && generator.isAir(blockPos = pos.south())) {
                this.placeVines(blockPos, VineBlock.NORTH, generator);
            }
        });
    }

    private void placeVines(BlockPos pos, BooleanProperty faceProperty, TreeDecorator.Context generator) {
        generator.setBlock(pos, (BlockState)this.block.defaultBlockState().setValue((Property)faceProperty, (Comparable)Boolean.TRUE));
        BlockPos var4 = pos.below();
        for (int i = 4; generator.isAir(var4) && i > 0; --i) {
            generator.setBlock(var4, (BlockState)this.block.defaultBlockState().setValue((Property)faceProperty, (Comparable)Boolean.TRUE));
            var4 = var4.below();
        }
    }
}

