/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.world.gen.features.custom;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class TreeGroupFeature
extends Feature<TreeConfiguration> {
    private static final int BLOCK_UPDATE_FLAGS = 19;

    public TreeGroupFeature(Codec<TreeConfiguration> codec) {
        super(codec);
    }

    private static boolean isVine(LevelSimulatedReader world, BlockPos pos) {
        return world.isStateAtPosition(pos, state -> state.is(Blocks.VINE));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader world, BlockPos pos) {
        return world.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.LEAVES));
    }

    private static void setBlockKnownShape(LevelWriter world, BlockPos pos, BlockState state) {
        world.setBlock(pos, state, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader world, BlockPos pos) {
        return world.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.REPLACEABLE_BY_TREES));
    }

    private boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> rootPlacerReplacer, BiConsumer<BlockPos, BlockState> trunkPlacerReplacer, FoliagePlacer.FoliageSetter foliageSetter, TreeConfiguration config) {
        int i = config.trunkPlacer.getTreeHeight(random);
        int j = config.foliagePlacer.foliageHeight(random, i, config);
        int k = i - j;
        int l = config.foliagePlacer.foliageRadius(random, k);
        BlockPos blockPos = config.rootPlacer.map(r -> r.getTrunkOrigin(pos, random)).orElse(pos);
        int minY = Math.min(pos.getY(), blockPos.getY());
        int maxY = Math.max(pos.getY(), blockPos.getY()) + i + 1;
        if (minY >= world.getMinBuildHeight() + 1 && maxY <= world.getMaxBuildHeight()) {
            OptionalInt minClipped = config.minimumSize.minClippedHeight();
            int top = this.getMaxFreeTreeHeight((LevelSimulatedReader)world, i, blockPos, config);
            if (top >= i || !minClipped.isEmpty() && top >= minClipped.getAsInt()) {
                if (config.rootPlacer.isPresent() && !((RootPlacer)config.rootPlacer.get()).placeRoots((LevelSimulatedReader)world, rootPlacerReplacer, random, pos, blockPos, config)) {
                    return false;
                }
                List list = config.trunkPlacer.placeTrunk((LevelSimulatedReader)world, trunkPlacerReplacer, random, top, blockPos, config);
                list.forEach(node -> config.foliagePlacer.createFoliage((LevelSimulatedReader)world, foliageSetter, random, config, top, node, j, l));
                return true;
            }
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader world, int height, BlockPos pos, TreeConfiguration config) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= height + 1; ++i) {
            int radius = config.minimumSize.getSizeAtHeight(height, i);
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    mutable.setWithOffset((Vec3i)pos, dx, i, dz);
                    if (config.trunkPlacer.isFree(world, (BlockPos)mutable) && (config.ignoreVines || !TreeGroupFeature.isVine(world, (BlockPos)mutable))) continue;
                    return i - 2;
                }
            }
        }
        return height;
    }

    protected void setBlock(LevelWriter world, BlockPos pos, BlockState state) {
        TreeGroupFeature.setBlockKnownShape(world, pos, state);
    }

    public final boolean place(FeaturePlaceContext<TreeConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        TreeConfiguration config = (TreeConfiguration)context.config();
        boolean success = false;
        success |= this.generateTree(world, random, origin, config);
        int count = 5 + random.nextInt(3);
        int radius = 8 + random.nextInt(5);
        for (int i = 0; i < count; ++i) {
            int dz;
            double angle = Math.PI * 2 * (double)i / (double)count + random.nextDouble();
            int dx = (int)(Math.cos(angle) * (double)radius);
            BlockPos offsetPos = origin.offset(dx, 0, dz = (int)(Math.sin(angle) * (double)radius));
            BlockPos ground = TreeGroupFeature.findGround(world, offsetPos);
            if (ground == null) continue;
            success |= this.generateTree(world, random, ground, config);
        }
        return success;
    }

    private boolean generateTree(final WorldGenLevel world, RandomSource random, BlockPos pos, TreeConfiguration config) {
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        final HashSet set3 = Sets.newHashSet();
        HashSet set4 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biConsumer = (p, s) -> {
            set.add(p.immutable());
            world.setBlock(p, s, 19);
        };
        BiConsumer<BlockPos, BlockState> biConsumer2 = (p, s) -> {
            set2.add(p.immutable());
            world.setBlock(p, s, 19);
        };
        FoliagePlacer.FoliageSetter foliageSetter = new FoliagePlacer.FoliageSetter(){

            public void set(BlockPos p, BlockState s) {
                set3.add(p.immutable());
                world.setBlock(p, s, 19);
            }

            public boolean isSet(BlockPos p) {
                return set3.contains(p);
            }
        };
        BiConsumer<BlockPos, BlockState> biConsumer3 = (p, s) -> {
            set4.add(p.immutable());
            world.setBlock(p, s, 19);
        };
        boolean bl = this.doPlace(world, random, pos, biConsumer, biConsumer2, foliageSetter, config);
        if (!(!bl || set2.isEmpty() && set3.isEmpty())) {
            if (!config.decorators.isEmpty()) {
                TreeDecorator.Context context = new TreeDecorator.Context((LevelSimulatedReader)world, biConsumer3, random, (Set)set2, (Set)set3, (Set)set);
                config.decorators.forEach(d -> d.place(context));
            }
            return BoundingBox.encapsulatingPositions((Iterable)Iterables.concat((Iterable)set, (Iterable)set2, (Iterable)set3, (Iterable)set4)).map(box -> {
                DiscreteVoxelShape shape = TreeGroupFeature.updateLeaves((LevelAccessor)world, box, set2, set4, set);
                StructureTemplate.updateShapeAtEdge((LevelAccessor)world, (int)3, (DiscreteVoxelShape)shape, (int)box.minX(), (int)box.minY(), (int)box.minZ());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static BlockPos findGround(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        while (mutable.getY() > world.getMinBuildHeight()) {
            if (!world.isEmptyBlock((BlockPos)mutable)) {
                return mutable.above();
            }
            mutable.move(Direction.DOWN);
        }
        return null;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor world, BoundingBox box, Set<BlockPos> trunkPositions, Set<BlockPos> decorationPositions, Set<BlockPos> rootPositions) {
        BitSetDiscreteVoxelShape shape = new BitSetDiscreteVoxelShape(box.getXSpan(), box.getYSpan(), box.getZSpan());
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < 7; ++j) {
            list.add(Sets.newHashSet());
        }
        for (BlockPos blockPos : Lists.newArrayList((Iterable)Sets.union(decorationPositions, rootPositions))) {
            if (!box.isInside((Vec3i)blockPos)) continue;
            shape.fill(blockPos.getX() - box.minX(), blockPos.getY() - box.minY(), blockPos.getZ() - box.minZ());
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int k = 0;
        ((Set)list.get(0)).addAll(trunkPositions);
        block2: while (true) {
            if (k >= 7 || !((Set)list.get(k)).isEmpty()) {
                if (k >= 7) {
                    return shape;
                }
                Iterator iterator = ((Set)list.get(k)).iterator();
                BlockPos bp = (BlockPos)iterator.next();
                iterator.remove();
                if (!box.isInside((Vec3i)bp)) continue;
                if (k != 0) {
                    BlockState state = world.getBlockState(bp);
                    TreeGroupFeature.setBlockKnownShape((LevelWriter)world, bp, (BlockState)state.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(k)));
                }
                shape.fill(bp.getX() - box.minX(), bp.getY() - box.minY(), bp.getZ() - box.minZ());
                Direction[] directionArray = Direction.values();
                int n = directionArray.length;
                int n2 = 0;
                while (true) {
                    int o;
                    BlockState state2;
                    OptionalInt optional;
                    int mz;
                    int my;
                    int mx;
                    if (n2 >= n) continue block2;
                    Direction dir = directionArray[n2];
                    mutable.setWithOffset((Vec3i)bp, dir);
                    if (box.isInside((Vec3i)mutable) && !shape.isFull(mx = mutable.getX() - box.minX(), my = mutable.getY() - box.minY(), mz = mutable.getZ() - box.minZ()) && !(optional = LeavesBlock.getOptionalDistanceAt((BlockState)(state2 = world.getBlockState((BlockPos)mutable)))).isEmpty() && (o = Math.min(optional.getAsInt(), k + 1)) < 7) {
                        ((Set)list.get(o)).add(mutable.immutable());
                        k = Math.min(k, o);
                    }
                    ++n2;
                }
            }
            ++k;
        }
    }
}

