/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.world.gen.features.custom;

import com.mojang.serialization.Codec;
import net.alminoris.wildfields.block.custom.TripleTallPlantBlock;
import net.alminoris.wildfields.world.gen.feature.custom.TripleTallPlantConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class TripleTallPlantFeature
extends Feature<TripleTallPlantConfig> {
    public TripleTallPlantFeature(Codec<TripleTallPlantConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<TripleTallPlantConfig> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BlockState baseState = ((TripleTallPlantConfig)context.config()).blockProvider.getState(random, origin);
        if (!(baseState.getBlock() instanceof TripleTallPlantBlock)) {
            return false;
        }
        if (origin.getY() >= world.getMaxBuildHeight() - 2) {
            return false;
        }
        BlockPos groundPos = origin.below();
        BlockState groundState = world.getBlockState(groundPos);
        if (!groundState.is(Blocks.GRASS_BLOCK) && !groundState.is(Blocks.DIRT)) {
            return false;
        }
        if (!(world.getBlockState(origin).canBeReplaced() && world.getBlockState(origin.above()).canBeReplaced() && world.getBlockState(origin.above(2)).canBeReplaced())) {
            return false;
        }
        Block lowerBlock = baseState.getBlock();
        BlockState lowerState = (BlockState)baseState.setValue(TripleTallPlantBlock.PART, (Comparable)((Object)TripleTallPlantBlock.PlantPart.LOWER));
        BlockState middleState = (BlockState)baseState.setValue(TripleTallPlantBlock.PART, (Comparable)((Object)TripleTallPlantBlock.PlantPart.MIDDLE));
        BlockState upperState = (BlockState)baseState.setValue(TripleTallPlantBlock.PART, (Comparable)((Object)TripleTallPlantBlock.PlantPart.UPPER));
        world.setBlock(origin, lowerState, 3);
        world.setBlock(origin.above(), middleState, 3);
        world.setBlock(origin.above(2), upperState, 3);
        return true;
    }
}

