/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.world.gen.decorator.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.alminoris.wildfields.world.gen.decorator.ModTreeDecorators;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4651;
import net.minecraft.class_4662;
import net.minecraft.class_4663;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class LeafCarpetDecorator
extends class_4662 {
    public static final Codec<LeafCarpetDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4651.field_24937.fieldOf("provider").forGetter(decorator -> decorator.provider), (App)Codec.INT.fieldOf("radius").forGetter(decorator -> decorator.radius), (App)Codec.INT.fieldOf("trunk_thickness").forGetter(decorator -> decorator.trunkThickness), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability))).apply((Applicative)instance, LeafCarpetDecorator::new));
    private final class_4651 provider;
    private final int radius;
    private final int trunkThickness;
    private final float probability;

    public LeafCarpetDecorator(class_4651 provider, int radius, int trunkThickness, float probability) {
        this.provider = provider;
        this.radius = radius;
        this.trunkThickness = trunkThickness;
        this.probability = probability;
    }

    protected class_4663<?> method_28893() {
        return ModTreeDecorators.LEAF_CARPET_DECORATOR;
    }

    public void method_23469(class_4662.class_7402 generator) {
        class_3746 world = generator.method_43316();
        ObjectArrayList logPositions = generator.method_43321();
        class_2338 lowestLog = logPositions.stream().min(Comparator.comparingInt(class_2382::method_10264)).orElse((class_2338)logPositions.get(0));
        this.placeLeafCarpets(generator, world, lowestLog, generator.method_43320());
    }

    private void placeLeafCarpets(class_4662.class_7402 generator, class_3746 world, class_2338 basePos, class_5819 random) {
        List<class_2248> validBlocks = Arrays.asList(class_2246.field_10566, class_2246.field_10219, class_2246.field_10340, class_2246.field_10520, class_2246.field_10102, class_2246.field_10255, class_2246.field_10491, class_2246.field_10402, class_2246.field_10253, class_2246.field_28685, class_2246.field_10382);
        List<class_2248> validBlocksWithoutWater = Arrays.asList(class_2246.field_10566, class_2246.field_10219, class_2246.field_10340, class_2246.field_10520, class_2246.field_10102, class_2246.field_10255, class_2246.field_10491, class_2246.field_10402, class_2246.field_10253, class_2246.field_28685);
        ObjectArrayList logPositions = generator.method_43321();
        class_2338.class_2339 carpetPos = new class_2338.class_2339();
        class_2338.class_2339 groundPos = new class_2338.class_2339();
        int min = -(this.trunkThickness / 2);
        int max = min + this.trunkThickness - 1;
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int z = -this.radius; z <= this.radius; ++z) {
                boolean groundIsLog;
                if (x >= min && x <= max && z >= min && z <= max || x * x + z * z > this.radius * this.radius || !(random.method_43057() < this.probability)) continue;
                carpetPos.method_10103(basePos.method_10263() + x, basePos.method_10264() + 1, basePos.method_10260() + z);
                groundPos.method_10103(basePos.method_10263() + x, basePos.method_10264(), basePos.method_10260() + z);
                class_2338 carpetImmutable = new class_2338(carpetPos.method_10263(), carpetPos.method_10264(), carpetPos.method_10260());
                class_2338 groundImmutable = new class_2338(groundPos.method_10263(), groundPos.method_10264(), groundPos.method_10260());
                boolean carpetIsLog = logPositions.stream().anyMatch(lp -> lp.method_10263() == carpetImmutable.method_10263() && lp.method_10264() == carpetImmutable.method_10264() && lp.method_10260() == carpetImmutable.method_10260());
                if (carpetIsLog || (groundIsLog = logPositions.stream().anyMatch(lp -> lp.method_10263() == groundImmutable.method_10263() && lp.method_10264() == groundImmutable.method_10264() && lp.method_10260() == groundImmutable.method_10260()))) continue;
                class_2680 providerState = this.provider.method_23455(generator.method_43320(), carpetImmutable);
                if (!world.method_16358(carpetImmutable, class_4970.class_4971::method_26215) || !world.method_16358(groundImmutable, state -> validBlocks.contains(state.method_26204()))) continue;
                generator.method_43318(carpetImmutable, providerState);
            }
        }
    }
}

