/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.world.gen.feature.custom;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4662;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7387;

public class TreeGroupFeature
extends class_3031<class_4643> {
    public TreeGroupFeature(Codec<class_4643> codec) {
        super(codec);
    }

    private static boolean isVine(class_3746 world, class_2338 pos) {
        return world.method_16358(pos, state -> state.method_27852(class_2246.field_10597));
    }

    public static boolean isAirOrLeaves(class_3746 world, class_2338 pos) {
        return world.method_16358(pos, state -> state.method_26215() || state.method_26164(class_3481.field_15503));
    }

    private static void setBlockStateWithoutUpdatingNeighbors(class_1945 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, 19);
    }

    public static boolean canReplace(class_3746 world, class_2338 pos) {
        return world.method_16358(pos, state -> state.method_26215() || state.method_26164(class_3481.field_44470));
    }

    private boolean generateSingle(class_5281 world, class_5819 random, class_2338 pos, BiConsumer<class_2338, class_2680> rootPlacerReplacer, BiConsumer<class_2338, class_2680> trunkPlacerReplacer, class_4647.class_8179 blockPlacer, class_4643 config) {
        int i = config.field_24136.method_26993(random);
        int j = config.field_24135.method_26989(random, i, config);
        int k = i - j;
        int l = config.field_24135.method_23452(random, k);
        class_2338 blockPos = config.field_38767.map(rootPlacer -> rootPlacer.method_43309(pos, random)).orElse(pos);
        int m = Math.min(pos.method_10264(), blockPos.method_10264());
        int n = Math.max(pos.method_10264(), blockPos.method_10264()) + i + 1;
        if (m >= world.method_31607() + 1 && n <= world.method_31600()) {
            OptionalInt optionalInt = config.field_24137.method_27377();
            int o = this.getTopPosition((class_3746)world, i, blockPos, config);
            if (o >= i || !optionalInt.isEmpty() && o >= optionalInt.getAsInt()) {
                if (config.field_38767.isPresent() && !((class_7387)config.field_38767.get()).method_43168((class_3746)world, rootPlacerReplacer, random, pos, blockPos, config)) {
                    return false;
                }
                List list = config.field_24136.method_26991((class_3746)world, trunkPlacerReplacer, random, o, blockPos, config);
                list.forEach(node -> config.field_24135.method_27385((class_3746)world, blockPlacer, random, config, o, node, j, l));
                return true;
            }
        }
        return false;
    }

    private int getTopPosition(class_3746 world, int height, class_2338 pos, class_4643 config) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i <= height + 1; ++i) {
            int j = config.field_24137.method_27378(height, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    mutable.method_25504((class_2382)pos, k, i, l);
                    if (config.field_24136.method_43198(world, (class_2338)mutable) && (config.field_24138 || !TreeGroupFeature.isVine(world, (class_2338)mutable))) continue;
                    return i - 2;
                }
            }
        }
        return height;
    }

    protected void method_13153(class_1945 world, class_2338 pos, class_2680 state) {
        TreeGroupFeature.setBlockStateWithoutUpdatingNeighbors(world, pos, state);
    }

    public boolean method_13151(class_5821<class_4643> context) {
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        class_2338 origin = context.method_33655();
        class_4643 config = (class_4643)context.method_33656();
        boolean success = false;
        success |= this.generateTree(world, random, origin, config);
        int count = 5 + random.method_43048(3);
        int radius = 8 + random.method_43048(5);
        for (int i = 0; i < count; ++i) {
            int dz;
            double angle = Math.PI * 2 * (double)i / (double)count + random.method_43058();
            int dx = (int)(Math.cos(angle) * (double)radius);
            class_2338 offsetPos = origin.method_10069(dx, 0, dz = (int)(Math.sin(angle) * (double)radius));
            class_2338 ground = TreeGroupFeature.findGround(world, offsetPos);
            if (ground == null) continue;
            success |= this.generateTree(world, random, ground, config);
        }
        return success;
    }

    private boolean generateTree(final class_5281 world, class_5819 random, class_2338 pos, class_4643 config) {
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        final HashSet set3 = Sets.newHashSet();
        HashSet set4 = Sets.newHashSet();
        BiConsumer<class_2338, class_2680> biConsumer = (p, s) -> {
            set.add(p.method_10062());
            world.method_8652(p, s, 19);
        };
        BiConsumer<class_2338, class_2680> biConsumer2 = (p, s) -> {
            set2.add(p.method_10062());
            world.method_8652(p, s, 19);
        };
        class_4647.class_8179 blockPlacer = new class_4647.class_8179(){

            public void method_49240(class_2338 p, class_2680 s) {
                set3.add(p.method_10062());
                world.method_8652(p, s, 19);
            }

            public boolean method_49239(class_2338 p) {
                return set3.contains(p);
            }
        };
        BiConsumer<class_2338, class_2680> biConsumer3 = (p, s) -> {
            set4.add(p.method_10062());
            world.method_8652(p, s, 19);
        };
        boolean bl = this.generateSingle(world, random, pos, biConsumer, biConsumer2, blockPlacer, config);
        if (!(!bl || set2.isEmpty() && set3.isEmpty())) {
            if (!config.field_21290.isEmpty()) {
                class_4662.class_7402 generator = new class_4662.class_7402((class_3746)world, biConsumer3, random, (Set)set2, (Set)set3, (Set)set);
                config.field_21290.forEach(decorator -> decorator.method_23469(generator));
            }
            return class_3341.method_35411((Iterable)Iterables.concat((Iterable)set, (Iterable)set2, (Iterable)set3, (Iterable)set4)).map(box -> {
                class_251 voxelSet = TreeGroupFeature.placeLogsAndLeaves((class_1936)world, box, set2, set4, set);
                class_3499.method_20532((class_1936)world, (int)3, (class_251)voxelSet, (int)box.method_35415(), (int)box.method_35416(), (int)box.method_35417());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static class_2338 findGround(class_5281 world, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        while (mutable.method_10264() > world.method_31607()) {
            if (!world.method_22347((class_2338)mutable)) {
                return mutable.method_10084();
            }
            mutable.method_10098(class_2350.field_11033);
        }
        return null;
    }

    private static class_251 placeLogsAndLeaves(class_1936 world, class_3341 box, Set<class_2338> trunkPositions, Set<class_2338> decorationPositions, Set<class_2338> rootPositions) {
        class_244 voxelSet = new class_244(box.method_35414(), box.method_14660(), box.method_14663());
        int i = 7;
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < 7; ++j) {
            list.add(Sets.newHashSet());
        }
        for (class_2338 blockPos : Lists.newArrayList((Iterable)Sets.union(decorationPositions, rootPositions))) {
            if (!box.method_14662((class_2382)blockPos)) continue;
            voxelSet.method_1049(blockPos.method_10263() - box.method_35415(), blockPos.method_10264() - box.method_35416(), blockPos.method_10260() - box.method_35417());
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int k = 0;
        ((Set)list.get(0)).addAll(trunkPositions);
        block2: while (true) {
            if (k >= 7 || !((Set)list.get(k)).isEmpty()) {
                if (k >= 7) {
                    return voxelSet;
                }
                Iterator iterator = ((Set)list.get(k)).iterator();
                class_2338 blockPos2 = (class_2338)iterator.next();
                iterator.remove();
                if (!box.method_14662((class_2382)blockPos2)) continue;
                if (k != 0) {
                    class_2680 blockState = world.method_8320(blockPos2);
                    TreeGroupFeature.setBlockStateWithoutUpdatingNeighbors((class_1945)world, blockPos2, (class_2680)blockState.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(k)));
                }
                voxelSet.method_1049(blockPos2.method_10263() - box.method_35415(), blockPos2.method_10264() - box.method_35416(), blockPos2.method_10260() - box.method_35417());
                class_2350[] class_2350Array = class_2350.values();
                int n = class_2350Array.length;
                int n2 = 0;
                while (true) {
                    int o;
                    class_2680 blockState2;
                    OptionalInt optionalInt;
                    int n3;
                    int m;
                    int l;
                    if (n2 >= n) continue block2;
                    class_2350 direction = class_2350Array[n2];
                    mutable.method_25505((class_2382)blockPos2, direction);
                    if (box.method_14662((class_2382)mutable) && !voxelSet.method_1063(l = mutable.method_10263() - box.method_35415(), m = mutable.method_10264() - box.method_35416(), n3 = mutable.method_10260() - box.method_35417()) && !(optionalInt = class_2397.method_49817((class_2680)(blockState2 = world.method_8320((class_2338)mutable)))).isEmpty() && (o = Math.min(optionalInt.getAsInt(), k + 1)) < 7) {
                        ((Set)list.get(o)).add(mutable.method_10062());
                        k = Math.min(k, o);
                    }
                    ++n2;
                }
            }
            ++k;
        }
    }
}

