/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields;

import com.mojang.logging.LogUtils;
import net.alminoris.wildfields.Config;
import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.block.entity.ModBlockEntities;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.client.AnimalGeoRenderer;
import net.alminoris.wildfields.entity.client.ModBoatRenderer;
import net.alminoris.wildfields.entity.client.projectile.SteppeArrowRenderer;
import net.alminoris.wildfields.item.ModItemGroups;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.particle.ModParticles;
import net.alminoris.wildfields.sound.ModSounds;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.alminoris.wildfields.world.biome.ModTerrablenderAPI;
import net.alminoris.wildfields.world.gen.decorator.ModTreeDecorators;
import net.alminoris.wildfields.world.gen.features.ModFeatures;
import net.alminoris.wildfields.world.tree.ModFoliagePlacerTypes;
import net.alminoris.wildfields.world.tree.ModTrunkPlacerTypes;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="wildfields")
public class WildFields {
    public static final String MOD_ID = "wildfields";
    private static final Logger LOGGER = LogUtils.getLogger();

    public WildFields(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModParticles.register(modEventBus);
        ModSounds.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModEntities.register(modEventBus);
        ModFeatures.register(modEventBus);
        ModTreeDecorators.register(modEventBus);
        ModTrunkPlacerTypes.register(modEventBus);
        ModFoliagePlacerTypes.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
        event.enqueueWork(() -> ModTerrablenderAPI.registerBiomes());
    }

    private void addCreative(CreativeModeTabEvent.BuildContents output) {
        if (output.getTab() == ModItemGroups.WILDFIELDS_TAB) {
            output.m_246326_((ItemLike)ModBlocks.FEATHER_GRASS.get());
            output.m_246326_((ItemLike)ModBlocks.TINY_GRASS.get());
            output.m_246326_((ItemLike)ModBlocks.THYME.get());
            output.m_246326_((ItemLike)ModBlocks.SPIDER_MILKWEED.get());
            output.m_246326_((ItemLike)ModBlocks.WORMWOOD.get());
            output.m_246326_((ItemLike)ModBlocks.PRAIRIE_ROSE.get());
            output.m_246326_((ItemLike)ModBlocks.SMOOTH_ASTER.get());
            output.m_246326_((ItemLike)ModBlocks.BLUE_GRAMA_GRASS.get());
            output.m_246326_((ItemLike)ModBlocks.PRAIRIE_SAGE.get());
            output.m_246326_((ItemLike)ModBlocks.VIOLA.get());
            for (String name : ModBlockSetsHelper.WILD_CROP_NAMES) {
                output.m_246326_((ItemLike)ModBlockSetsHelper.WILD_CROPS.get(name).get());
            }
            for (String name : ModBlockSetsHelper.CROP_NAMES) {
                output.m_246326_((ItemLike)ModBlockSetsHelper.CROP_SEEDS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.HAY_BLOCKS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.CROP_ITEMS.get(name).get());
            }
            output.m_246326_((ItemLike)ModBlocks.GREEN_LICHEN.get());
            output.m_246326_((ItemLike)ModBlocks.COTTONWOOD_FLUFF.get());
            for (String name : ModBlockSetsHelper.STONE_NAMES) {
                for (String type : ModBlockSetsHelper.STONE_TYPES) {
                    output.m_246326_((ItemLike)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get());
                    output.m_246326_((ItemLike)ModBlockSetsHelper.STONE_SLABS.get(name).get(type).get());
                    output.m_246326_((ItemLike)ModBlockSetsHelper.STONE_STAIRS.get(name).get(type).get());
                    output.m_246326_((ItemLike)ModBlockSetsHelper.STONE_WALLS.get(name).get(type).get());
                }
            }
            for (String name : ModBlockSetsHelper.WOOD_NAMES) {
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_SAPLINGS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.LEAVES.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.LOGS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.STRIPPED_LOGS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.STRIPPED_WOODS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_PLANKS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_SLABS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_STAIRS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_FENCES.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_FENCE_GATES.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_DOORS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_TRAPDOORS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_BUTTONS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_PRESSURE_PLATES.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_SIGN_ITEMS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_HANGING_SIGN_ITEMS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_BOATS.get(name).get());
                output.m_246326_((ItemLike)ModBlockSetsHelper.WOODEN_CHEST_BOATS.get(name).get());
            }
            output.m_246326_((ItemLike)ModItems.OLIVES.get());
            for (String name : ModBlockSetsHelper.BUSHES_NAMES) {
                output.m_246326_((ItemLike)ModBlockSetsHelper.BERRIES.get(name).get());
            }
            output.m_246326_((ItemLike)ModItems.FURRED_LEATHER_HELMET.get());
            output.m_246326_((ItemLike)ModItems.FURRED_LEATHER_CHESTPLATE.get());
            output.m_246326_((ItemLike)ModItems.FURRED_LEATHER_LEGGINGS.get());
            output.m_246326_((ItemLike)ModItems.FURRED_LEATHER_BOOTS.get());
            output.m_246326_((ItemLike)ModItems.DARKLING_BEETLE_CHESTPLATE.get());
            output.m_246326_((ItemLike)ModBlocks.SERVAL_HIDE.get());
            output.m_246326_((ItemLike)ModItems.STEPPE_ARROW.get());
            output.m_246326_((ItemLike)ModItems.SAIGA_SICKLE.get());
            output.m_246326_((ItemLike)ModItems.STEPPE_VIPER_DAGGER.get());
            output.m_246326_((ItemLike)ModItems.MARMOT_FUR.get());
            output.m_246326_((ItemLike)ModItems.DARKLING_BEETLE_SHELL.get());
            output.m_246326_((ItemLike)ModItems.STEPPE_EAGLE_BEAK.get());
            output.m_246326_((ItemLike)ModItems.STEPPE_EAGLE_FEATHER.get());
            output.m_246326_((ItemLike)ModItems.FERRUGINOUS_HAWK_FEATHER.get());
            output.m_246326_((ItemLike)ModItems.BLACK_BILLED_MAGPIE_FEATHER.get());
            output.m_246326_((ItemLike)ModItems.WESTERN_MEADOWLARK_FEATHER.get());
            output.m_246326_((ItemLike)ModItems.SAIGA_HORN.get());
            output.m_246326_((ItemLike)ModItems.BISON_HORN.get());
            output.m_246326_((ItemLike)ModItems.EARTHWORM.get());
            output.m_246326_((ItemLike)ModItems.PRAIRIES_TALISMAN.get());
            output.m_246326_((ItemLike)ModItems.STEPPE_VIPER_FANG.get());
            output.m_246326_((ItemLike)ModItems.SAIGA.get());
            output.m_246326_((ItemLike)ModItems.COOKED_SAIGA.get());
            output.m_246326_((ItemLike)ModItems.BISON.get());
            output.m_246326_((ItemLike)ModItems.COOKED_BISON.get());
            output.m_246326_((ItemLike)ModItems.JACKRABBIT.get());
            output.m_246326_((ItemLike)ModItems.COOKED_JACKRABBIT.get());
            output.m_246326_((ItemLike)ModItems.PALLID_WINGED_GRASSHOPPER_LEG.get());
            output.m_246326_((ItemLike)ModItems.COOKED_PALLID_WINGED_GRASSHOPPER_LEG.get());
            output.m_246326_((ItemLike)ModItems.BARLEY_BREAD.get());
            output.m_246326_((ItemLike)ModItems.BARLEY_STEW.get());
            output.m_246326_((ItemLike)ModItems.OAT_COOKIE.get());
            output.m_246326_((ItemLike)ModItems.OATMEAL.get());
            output.m_246326_((ItemLike)ModItems.MARMOT_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.DARKLING_BEETLE_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.SERVAL_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.STEPPE_EAGLE_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.SAIGA_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.STEPPE_VIPER_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.MOLE_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.COYOTE_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.BISON_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.FERRUGINOUS_HAWK_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.WHITE_TAILED_JACKRABBIT_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.PALLID_WINGED_GRASSHOPPER_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.BLACK_BILLED_MAGPIE_SPAWN_EGG.get());
            output.m_246326_((ItemLike)ModItems.WESTERN_MEADOWLARK_SPAWN_EGG.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="wildfields", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            for (String name : ModBlockSetsHelper.WOOD_NAMES) {
                Sheets.addWoodType((WoodType)ModBlockSetsHelper.WOOD_TYPES.get(name));
            }
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOD_BOAT.get()), pContext -> new ModBoatRenderer(pContext, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOD_CHEST_BOAT.get()), pContext -> new ModBoatRenderer(pContext, true));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SAIGA.get()), context -> new AnimalGeoRenderer(context, 1.2f, 0.8f, true, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SERVAL.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.DARKLING_BEETLE.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.4f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.STEPPE_VIPER.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.STEPPE_EAGLE.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MARMOT.get()), context -> new AnimalGeoRenderer(context, 1.2f, 0.6f, false, true));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOLE.get()), context -> new AnimalGeoRenderer(context, 0.75f, 0.35f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.COYOTE.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BISON.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, true, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.FERRUGINOUS_HAWK.get()), context -> new AnimalGeoRenderer(context, 1.0f, 0.6f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.WHITE_TAILED_JACKRABBIT.get()), context -> new AnimalGeoRenderer(context, 0.75f, 0.4f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.PALLID_WINGED_GRASSHOPPER.get()), context -> new AnimalGeoRenderer(context, 0.6f, 0.35f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BLACK_BILLED_MAGPIE.get()), context -> new AnimalGeoRenderer(context, 0.8f, 0.45f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.WESTERN_MEADOWLARK.get()), context -> new AnimalGeoRenderer(context, 0.8f, 0.45f, false, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.STEPPE_ARROW.get()), SteppeArrowRenderer::new);
            event.enqueueWork(() -> {
                for (String name : ModBlockSetsHelper.WOOD_NAMES) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.WOODEN_DOORS.get(name).get()), (RenderType)RenderType.m_110463_());
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.WOODEN_TRAPDOORS.get(name).get()), (RenderType)RenderType.m_110463_());
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.WOODEN_SAPLINGS.get(name).get()), (RenderType)RenderType.m_110463_());
                }
                for (String name : ModBlockSetsHelper.BUSHES_NAMES) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.BUSHES.get(name).get()), (RenderType)RenderType.m_110463_());
                }
                for (String name : ModBlockSetsHelper.WILD_CROP_NAMES) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.WILD_CROPS.get(name).get()), (RenderType)RenderType.m_110463_());
                }
                for (String name : ModBlockSetsHelper.CROP_NAMES) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlockSetsHelper.HAY_BLOCKS.get(name).get()), (RenderType)RenderType.m_110463_());
                }
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GREEN_LICHEN.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.FEATHER_GRASS.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.THYME.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SPIDER_MILKWEED.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WORMWOOD.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BLUE_GRAMA_GRASS.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.PRAIRIE_SAGE.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.PRAIRIE_ROSE.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SMOOTH_ASTER.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.VIOLA.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.TINY_GRASS.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.COTTONWOOD_FLUFF.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.COTTONWOOD_FLUFF.get()), (RenderType)RenderType.m_110466_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SERVAL_HIDE.get()), (RenderType)RenderType.m_110463_());
            });
        }
    }
}

