/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.block;

import java.util.function.Supplier;
import net.alminoris.wildfields.block.custom.AnimalHideBlock;
import net.alminoris.wildfields.block.custom.BerryBushBlock;
import net.alminoris.wildfields.block.custom.BushLeavesBlock;
import net.alminoris.wildfields.block.custom.CottonwoodFluffBlock;
import net.alminoris.wildfields.block.custom.CustomCropBlock;
import net.alminoris.wildfields.block.custom.FallingLeavesBlock;
import net.alminoris.wildfields.block.custom.ModHangingSignBlock;
import net.alminoris.wildfields.block.custom.ModStandingSignBlock;
import net.alminoris.wildfields.block.custom.ModWallHangingSignBlock;
import net.alminoris.wildfields.block.custom.ModWallSignBlock;
import net.alminoris.wildfields.block.custom.PricklyPearCactusBlock;
import net.alminoris.wildfields.block.custom.TripleTallPlantBlock;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.particle.ModParticles;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"wildfields");
    public static final RegistryObject<Block> THYME = ModBlocks.registerBlock("thyme", () -> new FlowerBlock(() -> MobEffects.f_19617_, 200, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50358_)));
    public static final RegistryObject<Block> POTTED_THYME = BLOCKS.register("potted_thyme", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, THYME, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50232_)));
    public static final RegistryObject<Block> SPIDER_MILKWEED = ModBlocks.registerBlock("spider_milkweed", () -> new FlowerBlock(() -> MobEffects.f_19616_, 12, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50358_)));
    public static final RegistryObject<Block> POTTED_SPIDER_MILKWEED = ModBlocks.registerBlock("potted_spider_milkweed", () -> new FlowerPotBlock((Block)SPIDER_MILKWEED.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50232_)));
    public static final RegistryObject<Block> WORMWOOD = ModBlocks.registerBlock("wormwood", () -> new FlowerBlock(() -> MobEffects.f_19607_, 12, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50358_)));
    public static final RegistryObject<Block> POTTED_WORMWOOD = ModBlocks.registerBlock("potted_wormwood", () -> new FlowerPotBlock((Block)WORMWOOD.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50232_)));
    public static final RegistryObject<Block> PRAIRIE_ROSE = ModBlocks.registerBlock("prairie_rose", () -> new FlowerBlock(() -> MobEffects.f_19605_, 12, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50358_)));
    public static final RegistryObject<Block> POTTED_PRAIRIE_ROSE = ModBlocks.registerBlock("potted_prairie_rose", () -> new FlowerPotBlock((Block)PRAIRIE_ROSE.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50232_)));
    public static final RegistryObject<Block> SMOOTH_ASTER = ModBlocks.registerBlock("smooth_aster", () -> new FlowerBlock(() -> MobEffects.f_19605_, 12, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50358_)));
    public static final RegistryObject<Block> POTTED_SMOOTH_ASTER = ModBlocks.registerBlock("potted_smooth_aster", () -> new FlowerPotBlock((Block)SMOOTH_ASTER.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50232_)));
    public static final RegistryObject<Block> FEATHER_GRASS = ModBlocks.registerBlock("feather_grass", () -> new TallGrassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_)));
    public static final RegistryObject<Block> GREEN_LICHEN = ModBlocks.registerBlock("green_lichen", () -> new VineBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50191_)));
    public static final RegistryObject<Block> TINY_GRASS = ModBlocks.registerBlock("tiny_grass", () -> new TallGrassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 90;
        }
    });
    public static final RegistryObject<Block> BLUE_GRAMA_GRASS = ModBlocks.registerBlock("blue_grama_grass", () -> new DoublePlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 90;
        }
    });
    public static final RegistryObject<Block> PRAIRIE_SAGE = ModBlocks.registerBlock("prairie_sage", () -> new TripleTallPlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 90;
        }
    });
    public static final RegistryObject<Block> SERVAL_HIDE = ModBlocks.registerBlock("serval_hide", () -> new AnimalHideBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50098_)));
    public static final RegistryObject<Block> VIOLA = ModBlocks.registerBlock("viola", () -> new PinkPetalsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_271445_)));
    public static final RegistryObject<Block> COTTONWOOD_FLUFF = ModBlocks.registerBlock("cottonwood_fluff", () -> new CottonwoodFluffBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60910_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    public static RegistryObject<Block> registerBushBlock(String name) {
        if (name.equals("prickly_pear")) {
            return ModBlocks.registerBlock(name, () -> new PricklyPearCactusBlock(name));
        }
        return ModBlocks.registerBlock(name, () -> new BerryBushBlock(name));
    }

    public static RegistryObject<Block> registerHayBlock(String name) {
        return ModBlocks.registerBlock(name + "_hay_block", () -> new HayBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50335_)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }
        });
    }

    public static RegistryObject<Block> registerWildCropBlock(String name) {
        return ModBlocks.registerBlock("wild_" + name, () -> new FlowerBlock(() -> MobEffects.f_19621_, 200, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 40;
            }
        });
    }

    public static RegistryObject<Block> registerCropBlock(String name) {
        return ModBlocks.registerBlock(name, () -> new CustomCropBlock(name));
    }

    public static RegistryObject<Block> registerStoneBlock(String name, String type) {
        return ModBlocks.registerBlock(name + "_" + type, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50334_)));
    }

    public static RegistryObject<Block> registerStoneSlab(String name, String type) {
        return ModBlocks.registerBlock(name + (String)(type.equals("block") ? "" : "_" + type) + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()))));
    }

    public static RegistryObject<Block> registerStoneStairs(String name, String type) {
        return ModBlocks.registerBlock(name + (String)(type.equals("block") ? "" : "_" + type) + "_stairs", () -> new StairBlock(((Block)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()))));
    }

    public static RegistryObject<Block> registerStoneWall(String name, String type) {
        return ModBlocks.registerBlock(name + (String)(type.equals("block") ? "" : "_" + type) + "_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type).get()))));
    }

    public static RegistryObject<Block> registerLeavesBlock(String name) {
        if (name.equals("tamarisk")) {
            return ModBlocks.registerBlock(name + "_leaves", () -> new BushLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60910_()){

                public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return true;
                }

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return 30;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return 60;
                }
            });
        }
        if (name.equals("olive")) {
            return ModBlocks.registerBlock(name + "_leaves", () -> new FallingLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_), (RegistryObject)ModParticles.OLIVE_LEAVES, 30){

                public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return true;
                }

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return 30;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return 60;
                }
            });
        }
        if (name.equals("trembling_aspen")) {
            return ModBlocks.registerBlock(name + "_leaves", () -> new FallingLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_), (RegistryObject)ModParticles.TREMBLING_ASPEN_LEAVES, 50){

                public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return true;
                }

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return 30;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return 60;
                }
            });
        }
        if (name.equals("cottonwood")) {
            return ModBlocks.registerBlock(name + "_leaves", () -> new FallingLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_), (RegistryObject)ModParticles.COTTONWOOD_LEAVES, 70){

                public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return true;
                }

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return 30;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return 60;
                }
            });
        }
        return ModBlocks.registerBlock(name + "_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }
        });
    }

    public static RegistryObject<Block> registerLogsBlock(String name) {
        return ModBlocks.registerBlock(name + "_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
    }

    public static RegistryObject<Block> registerWoodsBlock(String name) {
        return ModBlocks.registerBlock(name + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
    }

    public static RegistryObject<Block> registerStrippedLogsBlock(String name) {
        return ModBlocks.registerBlock("stripped_" + name + "_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
    }

    public static RegistryObject<Block> registerStrippedWoodsBlock(String name) {
        return ModBlocks.registerBlock("stripped_" + name + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        });
    }

    public static RegistryObject<Block> registerPlanksBlock(String name) {
        return ModBlocks.registerBlock(name + "_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }
        });
    }

    public static RegistryObject<Block> registerSlabBlock(String name) {
        return ModBlocks.registerBlock(name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)));
    }

    public static RegistryObject<Block> registerStairsBlock(String name, RegistryObject<Block> planks) {
        return ModBlocks.registerBlock(name + "_stairs", () -> new StairBlock(((Block)planks.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_)));
    }

    public static RegistryObject<Block> registerFenceBlock(String name) {
        return ModBlocks.registerBlock(name + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_)));
    }

    public static RegistryObject<Block> registerFenceGateBlock(String name) {
        return ModBlocks.registerBlock(name + "_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_), ModBlockSetsHelper.WOOD_TYPES.get(name)));
    }

    public static RegistryObject<Block> registerDoorBlock(String name) {
        return ModBlocks.registerBlock(name + "_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_), BlockSetType.f_271198_));
    }

    public static RegistryObject<Block> registerTrapdoorBlock(String name) {
        return ModBlocks.registerBlock(name + "_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), BlockSetType.f_271198_));
    }

    public static RegistryObject<Block> registerButtonBlock(String name) {
        return ModBlocks.registerBlock(name + "_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_), BlockSetType.f_271198_, 30, true));
    }

    public static RegistryObject<Block> registerPressurePlateBlock(String name) {
        return ModBlocks.registerBlock(name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BlockSetType.f_271198_));
    }

    public static RegistryObject<Block> registerSaplingBlock(String name, AbstractTreeGrower saplingGenerator) {
        return ModBlocks.registerBlock(name + "_sapling", () -> new SaplingBlock(saplingGenerator, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    }

    public static RegistryObject<Block> registerSignBlock(String name) {
        return ModBlocks.registerBlock(name + "_sign", () -> new ModStandingSignBlock(ModBlockSetsHelper.WOOD_TYPES.get(name), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50095_)));
    }

    public static RegistryObject<Block> registerWallSignBlock(String name) {
        return ModBlocks.registerBlock(name + "_wall_sign", () -> new ModWallSignBlock(ModBlockSetsHelper.WOOD_TYPES.get(name), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50158_)));
    }

    public static RegistryObject<Block> registerHangingSignBlock(String name) {
        return ModBlocks.registerBlock(name + "_hanging_sign", () -> new ModHangingSignBlock(ModBlockSetsHelper.WOOD_TYPES.get(name), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244319_)));
    }

    public static RegistryObject<Block> registerWallHangingSignBlock(String name) {
        return ModBlocks.registerBlock(name + "_wall_hanging_sign", () -> new ModWallHangingSignBlock(ModBlockSetsHelper.WOOD_TYPES.get(name), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244093_)));
    }
}

