/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.datagen;

import java.util.List;
import java.util.Map;
import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.item.ModArmorMaterials;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final List<TrimMaterial> TRIM_MATERIALS = List.of(new TrimMaterial("quartz", 0.1f, Map.of()), new TrimMaterial("iron", 0.2f, Map.of(ArmorMaterials.IRON, "iron_darker")), new TrimMaterial("netherite", 0.3f, Map.of(ArmorMaterials.NETHERITE, "netherite_darker")), new TrimMaterial("redstone", 0.4f, Map.of()), new TrimMaterial("copper", 0.5f, Map.of()), new TrimMaterial("gold", 0.6f, Map.of(ArmorMaterials.GOLD, "gold_darker")), new TrimMaterial("emerald", 0.7f, Map.of()), new TrimMaterial("diamond", 0.8f, Map.of(ArmorMaterials.DIAMOND, "diamond_darker")), new TrimMaterial("lapis", 0.9f, Map.of()), new TrimMaterial("amethyst", 1.0f, Map.of()));

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "wildfields", existingFileHelper);
    }

    protected void registerModels() {
        for (String name : ModBlockSetsHelper.WOOD_NAMES) {
            this.buttonItem(ModBlockSetsHelper.WOODEN_BUTTONS.get(name), ModBlockSetsHelper.WOODEN_PLANKS.get(name));
            this.fenceItem(ModBlockSetsHelper.WOODEN_FENCES.get(name), ModBlockSetsHelper.WOODEN_PLANKS.get(name));
            this.simpleBlockItem(ModBlockSetsHelper.WOODEN_DOORS.get(name));
            this.saplingItem(ModBlockSetsHelper.WOODEN_SAPLINGS.get(name));
            this.simpleItem(ModBlockSetsHelper.WOODEN_SIGN_ITEMS.get(name));
            this.simpleItem(ModBlockSetsHelper.WOODEN_HANGING_SIGN_ITEMS.get(name));
            this.simpleItem(ModBlockSetsHelper.WOODEN_BOATS.get(name));
            this.simpleItem(ModBlockSetsHelper.WOODEN_CHEST_BOATS.get(name));
        }
        this.withExistingParent(ModItems.MARMOT_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.STEPPE_EAGLE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.DARKLING_BEETLE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.STEPPE_VIPER_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.SAIGA_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.SERVAL_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.MOLE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.COYOTE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.BISON_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.FERRUGINOUS_HAWK_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.WHITE_TAILED_JACKRABBIT_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.PALLID_WINGED_GRASSHOPPER_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.BLACK_BILLED_MAGPIE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.WESTERN_MEADOWLARK_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.simpleItem(ModItems.OLIVES);
        this.simpleItem(((Block)ModBlocks.SERVAL_HIDE.get()).m_5456_());
        this.simpleItem(ModItems.DARKLING_BEETLE_SHELL);
        this.simpleItem(ModItems.MARMOT_FUR);
        this.simpleItem(ModItems.STEPPE_ARROW);
        this.simpleItem(ModItems.STEPPE_EAGLE_FEATHER);
        this.simpleItem(ModItems.STEPPE_EAGLE_BEAK);
        this.simpleItem(ModItems.STEPPE_VIPER_FANG);
        this.simpleItem(ModItems.STEPPE_VIPER_DAGGER);
        this.simpleItem(ModItems.SAIGA);
        this.simpleItem(ModItems.EARTHWORM);
        this.simpleItem(ModItems.SAIGA_HORN);
        this.simpleItem(ModItems.COOKED_SAIGA);
        this.simpleItem(ModItems.SAIGA_SICKLE);
        this.simpleItem(((Block)ModBlocks.PRAIRIE_SAGE.get()).m_5456_());
        this.simpleItem(((Block)ModBlocks.COTTONWOOD_FLUFF.get()).m_5456_());
        this.simpleDoubleBlockAsItem(ModBlocks.BLUE_GRAMA_GRASS);
        this.simpleBlockAsItem(ModBlocks.FEATHER_GRASS);
        this.simpleBlockAsItem(ModBlocks.TINY_GRASS);
        this.simpleBlockAsItem(ModBlocks.THYME);
        this.simpleBlockAsItem(ModBlocks.SPIDER_MILKWEED);
        this.simpleBlockAsItem(ModBlocks.WORMWOOD);
        this.simpleBlockAsItem(ModBlocks.PRAIRIE_ROSE);
        this.simpleBlockAsItem(ModBlocks.SMOOTH_ASTER);
        for (String name : ModBlockSetsHelper.WILD_CROP_NAMES) {
            this.simpleItem(((Block)ModBlockSetsHelper.WILD_CROPS.get(name).get()).m_5456_());
        }
        this.simpleItem(((Block)ModBlocks.VIOLA.get()).m_5456_());
        this.simpleItem(((Block)ModBlocks.GREEN_LICHEN.get()).m_5456_());
        for (String name : ModBlockSetsHelper.CROP_NAMES) {
            this.simpleItem((Item)ModBlockSetsHelper.CROP_ITEMS.get(name).get());
            this.simpleItem((Item)ModBlockSetsHelper.CROP_SEEDS.get(name).get());
        }
        for (String name : ModBlockSetsHelper.BUSHES_NAMES) {
            this.simpleItem((Item)ModBlockSetsHelper.BERRIES.get(name).get());
        }
        for (String name : ModBlockSetsHelper.STONE_NAMES) {
            for (String type : ModBlockSetsHelper.STONE_TYPES) {
                this.wallItem(ModBlockSetsHelper.STONE_WALLS.get(name).get(type), ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type));
            }
        }
        this.simpleItem(ModItems.BARLEY_BREAD);
        this.simpleItem(ModItems.BARLEY_STEW);
        this.simpleItem(ModItems.OAT_COOKIE);
        this.simpleItem(ModItems.OATMEAL);
        this.simpleItem(ModItems.JACKRABBIT);
        this.simpleItem(ModItems.COOKED_JACKRABBIT);
        this.simpleItem(ModItems.BISON_HORN);
        this.simpleItem(ModItems.BISON);
        this.simpleItem(ModItems.COOKED_BISON);
        this.simpleItem(ModItems.FERRUGINOUS_HAWK_FEATHER);
        this.simpleItem(ModItems.PALLID_WINGED_GRASSHOPPER_LEG);
        this.simpleItem(ModItems.COOKED_PALLID_WINGED_GRASSHOPPER_LEG);
        this.simpleItem(ModItems.BLACK_BILLED_MAGPIE_FEATHER);
        this.simpleItem(ModItems.WESTERN_MEADOWLARK_FEATHER);
        this.simpleItem(ModItems.PRAIRIES_TALISMAN);
        this.trimmedArmorItem(ModItems.DARKLING_BEETLE_CHESTPLATE);
        this.trimmedArmorItem(ModItems.FURRED_LEATHER_HELMET);
        this.trimmedArmorItem(ModItems.FURRED_LEATHER_CHESTPLATE);
        this.trimmedArmorItem(ModItems.FURRED_LEATHER_LEGGINGS);
        this.trimmedArmorItem(ModItems.FURRED_LEATHER_BOOTS);
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        if (itemRegistryObject == null) {
            return;
        }
        Item item = (Item)itemRegistryObject.get();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)item;
        String itemPath = itemRegistryObject.getId().m_135815_();
        String armorType = switch (armorItem.m_40402_()) {
            case EquipmentSlot.HEAD -> "helmet";
            case EquipmentSlot.CHEST -> "chestplate";
            case EquipmentSlot.LEGS -> "leggings";
            case EquipmentSlot.FEET -> "boots";
            default -> {
                String lower = itemPath.toLowerCase();
                if (lower.contains("helmet")) {
                    yield "helmet";
                }
                if (lower.contains("chestplate")) {
                    yield "chestplate";
                }
                if (lower.contains("leggings") || lower.contains("legs")) {
                    yield "leggings";
                }
                if (lower.contains("boots") || lower.contains("boot")) {
                    yield "boots";
                }
                yield "helmet";
            }
        };
        ResourceLocation baseItemTexture = ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("item/" + itemPath));
        ResourceLocation overlayTexture = ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("item/" + itemPath + "_overlay"));
        boolean isFurredLeather = armorItem.m_40401_() == ModArmorMaterials.FURRED_LEATHER;
        for (TrimMaterial trimMaterial : TRIM_MATERIALS) {
            float trimValue = trimMaterial.itemModelIndex();
            String appliedTrimName = trimMaterial.getAppliedName(armorItem.m_40401_());
            String trimTexturePath = "trims/items/" + armorType + "_trim_" + appliedTrimName;
            ResourceLocation trimTextureRes = ResourceLocation.m_135820_((String)trimTexturePath);
            if (trimTextureRes == null) {
                trimTextureRes = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)trimTexturePath);
            }
            String trimmedModelName = itemPath + "_" + appliedTrimName + "_trim";
            this.existingFileHelper.trackGenerated(trimTextureRes, PackType.CLIENT_RESOURCES, ".png", "textures");
            if (isFurredLeather) {
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(trimmedModelName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", baseItemTexture.m_135827_() + ":item/" + baseItemTexture.m_135815_().replaceFirst("^item/", ""))).texture("layer1", overlayTexture.m_135827_() + ":item/" + overlayTexture.m_135815_().replaceFirst("^item/", ""))).texture("layer2", trimTextureRes);
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimmedModelName)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", baseItemTexture)).texture("layer1", overlayTexture);
                continue;
            }
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(trimmedModelName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", baseItemTexture.m_135827_() + ":item/" + baseItemTexture.m_135815_().replaceFirst("^item/", ""))).texture("layer1", trimTextureRes);
            ((ItemModelBuilder)this.withExistingParent(itemPath, this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimmedModelName)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", baseItemTexture);
        }
    }

    public void wallItem(RegistryObject<? extends Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_())));
    }

    private ItemModelBuilder saplingItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("block/" + item.getId().m_135815_())));
    }

    public void buttonItem(RegistryObject<? extends Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/button_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_())));
    }

    public void fenceItem(RegistryObject<? extends Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_())));
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("item/" + item.getId().m_135815_())));
    }

    private ItemModelBuilder simpleItem(Item item) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("item/" + id.m_135815_())));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<? extends Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("item/" + item.getId().m_135815_())));
    }

    private ItemModelBuilder simpleBlockAsItem(RegistryObject<? extends Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("block/" + item.getId().m_135815_())));
    }

    private ItemModelBuilder simpleDoubleBlockAsItem(RegistryObject<? extends Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("block/" + item.getId().m_135815_() + "_top")));
    }

    private record TrimMaterial(String name, float itemModelIndex, Map<ArmorMaterial, String> overrideArmorMaterials) {
        public String getAppliedName(ArmorMaterial armorMaterial) {
            return this.overrideArmorMaterials.getOrDefault(armorMaterial, this.name);
        }
    }
}

