/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.client;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class AnimalGeoModel<T extends Animal>
extends GeoModel<T> {
    protected String resolveName(T animatable) {
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)animatable.m_6095_());
        if (key != null) {
            return key.m_135815_();
        }
        return animatable.m_20078_();
    }

    public ResourceLocation getModelResource(T animatable) {
        String name = this.resolveName(animatable);
        return ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("geo/" + name + ".geo.json"));
    }

    public ResourceLocation getTextureResource(T animatable) {
        String name = this.resolveName(animatable);
        return ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("textures/entity/" + name + ".png"));
    }

    public ResourceLocation getAnimationResource(T animatable) {
        String name = this.resolveName(animatable);
        return ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)("animations/" + name + ".animation.json"));
    }

    protected void applyHeadRotations(T animatable, AnimationState<T> animationState, String headBoneName) {
        CoreGeoBone head = this.getAnimationProcessor().getBone(headBoneName);
        if (head == null) {
            return;
        }
        EntityModelData data = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (data == null) {
            return;
        }
        head.setRotX(data.headPitch() * ((float)Math.PI / 180));
        head.setRotY(data.netHeadYaw() * ((float)Math.PI / 180));
    }

    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        this.applyHeadRotations(animatable, animationState, "head");
    }
}

