/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.entity.custom;

import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.custom.ai.goal.EatHeldItemGoal;
import net.alminoris.wildfields.entity.custom.ai.goal.PickUpItemGoal;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.sound.ModSounds;
import net.alminoris.wildfields.util.ModTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class MarmotEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean isPickUp = false;
    private static final int EXPLORE_DURATION = 400;
    private static int exploreInterval = 1800;
    private int exploreTimer = exploreInterval;
    private static final EntityDataAccessor<Boolean> DATA_EXPLORING = SynchedEntityData.m_135353_(MarmotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public MarmotEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.f_21342_ = new MoveControl((Mob)this);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 9.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22284_, 0.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new PickUpItemGoal((PathfinderMob)this, 1.0, new Item[]{(Item)ModItems.OLIVES.get(), Items.f_42780_, ((Block)ModBlocks.TINY_GRASS.get()).m_5456_(), Items.f_41864_, Items.f_42404_}){

            @Override
            public boolean m_8036_() {
                return !MarmotEntity.this.isExploring() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new EatHeldItemGoal((Animal)this, new Item[]{((Block)ModBlocks.TINY_GRASS.get()).m_5456_(), Items.f_41864_, Items.f_42404_}){

            @Override
            public boolean m_8036_() {
                return !MarmotEntity.this.isExploring() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 0.85));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 0.8, Ingredient.m_204132_(ModTags.Items.MARMOT_FOOD), false));
        this.f_21345_.m_25352_(7, (Goal)new FollowParentGoal((Animal)this, 0.75));
        this.f_21345_.m_25352_(8, (Goal)new PanicGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.75));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_EXPLORING, (Object)false);
    }

    public boolean isExploring() {
        return (Boolean)this.f_19804_.m_135370_(DATA_EXPLORING);
    }

    public void setExploring(boolean explore) {
        this.f_19804_.m_135381_(DATA_EXPLORING, (Object)explore);
        this.m_20124_(explore ? Pose.SITTING : Pose.STANDING);
        if (explore) {
            this.m_21573_().m_26573_();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsExploring", this.isExploring());
        compound.m_128405_("ExploreTimer", this.exploreTimer);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("IsExploring")) {
            this.setExploring(compound.m_128471_("IsExploring"));
        }
        if (compound.m_128441_("ExploreTimer")) {
            this.exploreTimer = compound.m_128451_("ExploreTimer");
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.m_21827_()) {
            exploreInterval = 3200 + this.f_19796_.m_188503_(3801);
            if (!this.isExploring() && this.exploreTimer > 0) {
                --this.exploreTimer;
            } else if (!this.isExploring() && this.exploreTimer <= 0) {
                this.setExploring(true);
                this.exploreTimer = 400;
            }
            if (this.isExploring() && this.exploreTimer > 0) {
                --this.exploreTimer;
            } else if (this.isExploring() && this.exploreTimer <= 0) {
                this.setExploring(false);
                this.exploreTimer = exploreInterval;
            }
            if (this.isExploring() && this.m_20069_()) {
                this.setExploring(false);
                this.exploreTimer = exploreInterval;
            }
        }
    }

    public void m_7023_(Vec3 pVec) {
        if (this.isExploring()) {
            this.m_20256_(Vec3.f_82478_);
            return;
        }
        super.m_7023_(pVec);
    }

    protected float m_6118_() {
        return super.m_6118_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SOUND_MARMOT_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModSounds.SOUND_MARMOT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SOUND_MARMOT_DEATH.get();
    }

    @Nullable
    public MarmotEntity getBreedOffspring(ServerLevel level, AgeableMob mate) {
        Entity entity = ((EntityType)ModEntities.MARMOT.get()).m_20615_((Level)level);
        if (entity instanceof MarmotEntity) {
            return (MarmotEntity)entity;
        }
        return null;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.MARMOT_FOOD);
    }

    protected void m_7625_(DamageSource source, boolean causedByPlayer) {
        super.m_7625_(source, causedByPlayer);
        RandomSource rnd = this.m_9236_().f_46441_;
        if (rnd.m_188501_() < 0.2f) {
            this.m_19998_((ItemLike)ModItems.MARMOT_FUR.get());
        }
        if (rnd.m_188501_() < 0.05f) {
            this.m_19998_((ItemLike)ModBlocks.TINY_GRASS.get());
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_9236_().f_46443_) {
            return InteractionResult.m_19078_((boolean)true);
        }
        if (this.m_21824_()) {
            if (this.m_6898_(stack) && this.m_21223_() < this.m_21233_()) {
                stack.m_41774_(1);
                this.m_5634_(2.0f);
                return InteractionResult.SUCCESS;
            }
            if (player.equals((Object)this.m_269323_())) {
                this.m_21839_(!this.m_21827_());
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == Items.f_42404_ && !this.isExploring()) {
            stack.m_41774_(1);
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.m_21827_()) {
                return state.setAndContinue(RawAnimation.begin().then("sit", Animation.LoopType.HOLD_ON_LAST_FRAME));
            }
            if (this.isExploring()) {
                return state.setAndContinue(RawAnimation.begin().then("exploring", Animation.LoopType.PLAY_ONCE));
            }
            if (this.isPickUp) {
                this.isPickUp = false;
                return state.setAndContinue(RawAnimation.begin().then("pickup", Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void triggerPickUpAnimation() {
        this.isPickUp = true;
    }

    public void resetPickUpAnimation() {
        this.isPickUp = false;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (pose == Pose.SITTING) {
            return EntityDimensions.m_20395_((float)this.m_6095_().m_20678_(), (float)(this.m_6095_().m_20679_() - 0.5f));
        }
        return super.m_6972_(pose);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_21839_(false);
        return super.m_6469_(source, amount);
    }

    public int m_5792_() {
        return 15;
    }
}

