/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.event;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.alminoris.wildfields.item.ModItems;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wildfields")
public class PrairieTalismanHandler {
    private static final Map<UUID, Vec3> LAST_POS = new ConcurrentHashMap<UUID, Vec3>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerLevel level : event.getServer().m_129785_()) {
            for (ServerPlayer player : level.m_6907_()) {
                Vec3 currPos = player.m_20182_();
                Vec3 prevPos = LAST_POS.get(player.m_20148_());
                if (prevPos == null) {
                    LAST_POS.put(player.m_20148_(), currPos);
                    continue;
                }
                double dx = currPos.f_82479_ - prevPos.f_82479_;
                double dy = currPos.f_82480_ - prevPos.f_82480_;
                double dz = currPos.f_82481_ - prevPos.f_82481_;
                double horizSq = dx * dx + dz * dz;
                boolean isMoving = horizSq > 1.0E-6;
                boolean isSprinting = player.m_20142_();
                boolean isFalling = !player.m_20096_() && dy < -0.08;
                ItemStack talismanStack = ItemStack.f_41583_;
                int talismanSlot = -1;
                for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                    if (!stack.m_150930_((Item)ModItems.PRAIRIES_TALISMAN.get())) continue;
                    talismanStack = stack;
                    talismanSlot = i;
                    break;
                }
                if (!talismanStack.m_41619_() && talismanStack.m_41773_() < talismanStack.m_41776_()) {
                    Biome biome = (Biome)level.m_204166_(player.m_20183_()).m_203334_();
                    ResourceLocation biomeId = level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
                    if (biomeId != null && biomeId.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"wildfields", (String)"prairies_biome"))) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 40, 0, true, false, false));
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 40, 0, true, false, false));
                        int damage = 0;
                        if (isFalling) {
                            damage = 10;
                        } else if (isSprinting) {
                            damage = 5;
                        } else if (isMoving) {
                            damage = 2;
                        }
                        if (damage > 0 && player.m_9236_().m_46467_() % 20L == 0L) {
                            talismanStack.m_41622_(damage, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                            if (talismanStack.m_41773_() >= talismanStack.m_41776_()) {
                                player.m_150109_().m_8016_(talismanSlot);
                            }
                        }
                    }
                }
                LAST_POS.put(player.m_20148_(), currPos);
            }
        }
    }
}

