/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.item;

import java.util.EnumMap;
import java.util.function.Supplier;
import net.alminoris.wildfields.item.ModItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ModArmorMaterials {
    public static final ArmorMaterial DARKLING_BEETLE_SHELL = ModArmorMaterials.createArmorMaterial("darkling_beetle_shell", UtilArmorValues.map(4, 8, 12, 4), 10, SoundEvents.f_11679_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DARKLING_BEETLE_SHELL.get()}), 2.0f, 0.5f);
    public static final ArmorMaterial FURRED_LEATHER = ModArmorMaterials.createArmorMaterial("furred_leather", UtilArmorValues.map(2, 3, 4, 1), 20, SoundEvents.f_11678_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MARMOT_FUR.get()}), 0.0f, 0.0f);

    private static ArmorMaterial createArmorMaterial(final String name, final EnumMap<ArmorItem.Type, Integer> defensePoints, final int enchantability, final SoundEvent equipSound, final Supplier<Ingredient> repairMaterial, final float toughness, final float knockbackResistance) {
        return new ArmorMaterial(){
            private final EnumMap<ArmorItem.Type, Integer> defense;
            {
                this.defense = defensePoints;
            }

            public int m_266425_(ArmorItem.Type type) {
                return UtilArmorValues.BASE_DURABILITY.get(type);
            }

            public int m_7366_(ArmorItem.Type type) {
                return this.defense.getOrDefault(type, 0);
            }

            public int m_6646_() {
                return enchantability;
            }

            public SoundEvent m_7344_() {
                return equipSound;
            }

            public Ingredient m_6230_() {
                return (Ingredient)repairMaterial.get();
            }

            public String m_6082_() {
                return "wildfields:" + name;
            }

            public float m_6651_() {
                return toughness;
            }

            public float m_6649_() {
                return knockbackResistance;
            }
        };
    }

    public static class UtilArmorValues {
        public static final EnumMap<ArmorItem.Type, Integer> BASE_DURABILITY = UtilArmorValues.makeBaseDurability();

        private static EnumMap<ArmorItem.Type, Integer> makeBaseDurability() {
            EnumMap<ArmorItem.Type, Integer> map = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
            map.put(ArmorItem.Type.HELMET, 11);
            map.put(ArmorItem.Type.CHESTPLATE, 16);
            map.put(ArmorItem.Type.LEGGINGS, 15);
            map.put(ArmorItem.Type.BOOTS, 13);
            return map;
        }

        public static EnumMap<ArmorItem.Type, Integer> map(int helmet, int leggings, int chestplate, int boots) {
            EnumMap<ArmorItem.Type, Integer> map = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
            map.put(ArmorItem.Type.HELMET, helmet);
            map.put(ArmorItem.Type.LEGGINGS, leggings);
            map.put(ArmorItem.Type.CHESTPLATE, chestplate);
            map.put(ArmorItem.Type.BOOTS, boots);
            return map;
        }
    }
}

