/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields.datagen;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.item.ModArmorMaterials;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_6880;

public class ModModelProvider
extends FabricModelProvider {
    private static final List<TrimMaterial> TRIM_MATERIALS = List.of(new TrimMaterial("quartz", 0.1f, Map.of()), new TrimMaterial("iron", 0.2f, Map.of(class_1740.field_7892, "iron_darker")), new TrimMaterial("netherite", 0.3f, Map.of(class_1740.field_21977, "netherite_darker")), new TrimMaterial("redstone", 0.4f, Map.of()), new TrimMaterial("copper", 0.5f, Map.of()), new TrimMaterial("gold", 0.6f, Map.of(class_1740.field_7895, "gold_darker")), new TrimMaterial("emerald", 0.7f, Map.of()), new TrimMaterial("diamond", 0.8f, Map.of(class_1740.field_7889, "diamond_darker")), new TrimMaterial("lapis", 0.9f, Map.of()), new TrimMaterial("amethyst", 1.0f, Map.of()));

    public ModModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(final class_4910 blockStateModelGenerator) {
        Hashtable<String, class_4910.class_4912> woodenPlanksPool = new Hashtable<String, class_4910.class_4912>(){
            {
                for (String name : ModBlockSetsHelper.WOOD_NAMES) {
                    this.put(name, blockStateModelGenerator.method_25650(ModBlockSetsHelper.WOODEN_PLANKS.get(name)));
                }
            }
        };
        for (String name : ModBlockSetsHelper.WOOD_NAMES) {
            ((class_4910.class_4912)((Dictionary)woodenPlanksPool).get(name)).method_25724(ModBlockSetsHelper.WOODEN_SLABS.get(name));
            ((class_4910.class_4912)((Dictionary)woodenPlanksPool).get(name)).method_25725(ModBlockSetsHelper.WOODEN_STAIRS.get(name));
            this.registerLogBlock(blockStateModelGenerator, ModBlockSetsHelper.LOGS.get(name), class_2960.method_60655((String)"wildfields", (String)("block/" + name + "_log_top")), class_2960.method_60655((String)"wildfields", (String)("block/" + name + "_log")));
            this.registerLogBlock(blockStateModelGenerator, ModBlockSetsHelper.STRIPPED_LOGS.get(name), class_2960.method_60655((String)"wildfields", (String)("block/stripped_" + name + "_log_top")), class_2960.method_60655((String)"wildfields", (String)("block/stripped_" + name + "_log")));
            this.registerLogBlock(blockStateModelGenerator, ModBlockSetsHelper.WOODS.get(name), class_2960.method_60655((String)"wildfields", (String)("block/" + name + "_log")), class_2960.method_60655((String)"wildfields", (String)("block/" + name + "_log")));
            this.registerLogBlock(blockStateModelGenerator, ModBlockSetsHelper.STRIPPED_WOODS.get(name), class_2960.method_60655((String)"wildfields", (String)("block/stripped_" + name + "_log")), class_2960.method_60655((String)"wildfields", (String)("block/stripped_" + name + "_log")));
            blockStateModelGenerator.method_25622(ModBlockSetsHelper.LEAVES.get(name), class_4946.field_23049);
            blockStateModelGenerator.method_25548(ModBlockSetsHelper.WOODEN_SAPLINGS.get(name), class_4910.class_4913.field_22840);
            blockStateModelGenerator.method_25658(ModBlockSetsHelper.WOODEN_DOORS.get(name));
            blockStateModelGenerator.method_25665(ModBlockSetsHelper.WOODEN_TRAPDOORS.get(name));
            ((class_4910.class_4912)((Dictionary)woodenPlanksPool).get(name)).method_25721(ModBlockSetsHelper.WOODEN_FENCES.get(name));
            ((class_4910.class_4912)((Dictionary)woodenPlanksPool).get(name)).method_25722(ModBlockSetsHelper.WOODEN_FENCE_GATES.get(name));
            ((class_4910.class_4912)((Dictionary)woodenPlanksPool).get(name)).method_25716(ModBlockSetsHelper.WOODEN_BUTTONS.get(name));
            ((class_4910.class_4912)((Dictionary)woodenPlanksPool).get(name)).method_25723(ModBlockSetsHelper.WOODEN_PRESSURE_PLATES.get(name));
            ((class_4910.class_4912)((Dictionary)woodenPlanksPool).get(name)).method_33522(ModBlockSetsHelper.WOODEN_BLOCK_FAMILIES.get(name));
            this.registerHangingSign(blockStateModelGenerator, ModBlockSetsHelper.STRIPPED_LOGS.get(name), ModBlockSetsHelper.WOODEN_HANGING_SIGNS.get(name), ModBlockSetsHelper.WOODEN_WALL_HANGING_SIGNS.get(name));
        }
        for (String name : ModBlockSetsHelper.BUSHES_NAMES) {
            blockStateModelGenerator.method_49374(ModBlockSetsHelper.BUSHES.get(name), class_4910.class_4913.field_22840, (class_2769)class_2741.field_12497, new int[]{0, 1, 2, 3});
        }
        blockStateModelGenerator.method_49374(ModBlocks.PRICKLY_PEAR_CACTUS, class_4910.class_4913.field_22840, (class_2769)class_2741.field_12497, new int[]{0, 1, 2, 3});
        blockStateModelGenerator.method_25621(ModBlocks.BLUE_GRAMA_GRASS, class_4910.class_4913.field_22839);
        blockStateModelGenerator.method_25545(ModBlocks.THYME, ModBlocks.POTTED_THYME, class_4910.class_4913.field_22840);
        blockStateModelGenerator.method_25545(ModBlocks.SPIDER_MILKWEED, ModBlocks.POTTED_SPIDER_MILKWEED, class_4910.class_4913.field_22840);
        blockStateModelGenerator.method_25545(ModBlocks.WORMWOOD, ModBlocks.POTTED_WORMWOOD, class_4910.class_4913.field_22840);
        blockStateModelGenerator.method_25545(ModBlocks.PRAIRIE_ROSE, ModBlocks.POTTED_PRAIRIE_ROSE, class_4910.class_4913.field_22840);
        blockStateModelGenerator.method_25545(ModBlocks.SMOOTH_ASTER, ModBlocks.POTTED_SMOOTH_ASTER, class_4910.class_4913.field_22840);
        blockStateModelGenerator.method_25548(ModBlocks.FEATHER_GRASS, class_4910.class_4913.field_22840);
        blockStateModelGenerator.method_25548(ModBlocks.TINY_GRASS, class_4910.class_4913.field_22839);
        blockStateModelGenerator.method_33520(ModBlocks.GREEN_LICHEN);
        for (String name : ModBlockSetsHelper.STONE_NAMES) {
            for (String type : ModBlockSetsHelper.STONE_TYPES) {
                class_4910.class_4912 stonePool = blockStateModelGenerator.method_25650(ModBlockSetsHelper.STONE_BLOCKS.get(name).get(type));
                stonePool.method_25724(ModBlockSetsHelper.STONE_SLABS.get(name).get(type));
                stonePool.method_25725(ModBlockSetsHelper.STONE_STAIRS.get(name).get(type));
                stonePool.method_25720(ModBlockSetsHelper.STONE_WALLS.get(name).get(type));
            }
        }
        blockStateModelGenerator.method_25538(ModItems.MARMOT_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.STEPPE_EAGLE_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.DARKLING_BEETLE_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.STEPPE_VIPER_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.SAIGA_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.SERVAL_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.MOLE_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.COYOTE_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.BISON_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.FERRUGINOUS_HAWK_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.WHITE_TAILED_JACKRABBIT_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.PALLID_WINGED_GRASSHOPPER_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.BLACK_BILLED_MAGPIE_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        blockStateModelGenerator.method_25538(ModItems.WESTERN_MEADOWLARK_SPAWN_EGG, class_4941.method_25845((String)"template_spawn_egg"));
        for (String name : ModBlockSetsHelper.WILD_CROP_NAMES) {
            blockStateModelGenerator.method_25681(ModBlockSetsHelper.WILD_CROPS.get(name));
        }
        for (String name : ModBlockSetsHelper.CROP_NAMES) {
            blockStateModelGenerator.method_25554(ModBlockSetsHelper.HAY_BLOCKS.get(name), class_4946.field_23038, class_4946.field_23039);
            blockStateModelGenerator.method_25547(ModBlockSetsHelper.CROPS.get(name), (class_2769)class_2741.field_12550, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        }
        blockStateModelGenerator.method_49378(ModBlocks.VIOLA);
    }

    private void registerLilyPad(class_4910 blockStateModelGenerator, class_2248 block) {
        blockStateModelGenerator.method_25600(block);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25634((class_2248)block, (class_2960)class_4941.method_25842((class_2248)block)));
    }

    private void registerGrassBlock(class_4910 generator, class_2248 grassBlock) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23014, class_4944.method_25860((class_2248)class_2246.field_10566)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)grassBlock, (String)"_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)grassBlock, (String)"_side"));
        generator.field_22830.accept(class_4910.method_25644((class_2248)grassBlock, (class_2960)class_4943.field_22977.method_25846(grassBlock, textureMap, generator.field_22831)));
    }

    public final void registerCarpet(class_4910 blockStateModelGenerator, class_2248 wool, class_2248 carpet) {
        class_2960 identifier = class_4946.field_23044.get(wool).method_25916(carpet, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)carpet, (class_2960)identifier));
    }

    private void registerHangingSign(class_4910 blockStateModelGenerator, class_2248 strippedLog, class_2248 hangingSign, class_2248 wallHangingSign) {
        class_4944 textureMap = class_4944.method_25901((class_2248)strippedLog);
        class_2960 identifier = class_4943.field_22908.method_25846(hangingSign, textureMap, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)hangingSign, (class_2960)identifier));
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)wallHangingSign, (class_2960)identifier));
    }

    private void registerLogBlock(class_4910 generator, class_2248 logBlock, class_2960 topTexture, class_2960 sideTexture) {
        Function<class_2248, class_4944> texturesGetter = block -> new class_4944().method_25868(class_4945.field_23015, topTexture).method_25868(class_4945.field_23018, sideTexture).method_25868(class_4945.field_23013, topTexture);
        generator.method_25554(logBlock, class_4946.method_25918(texturesGetter, (class_4942)class_4943.field_22974), class_4946.method_25918(texturesGetter, (class_4942)class_4943.field_22975));
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        for (String name : ModBlockSetsHelper.WOOD_NAMES) {
            itemModelGenerator.method_25733(ModBlockSetsHelper.WOODEN_BOATS.get(name), class_4943.field_22938);
            itemModelGenerator.method_25733(ModBlockSetsHelper.WOODEN_CHEST_BOATS.get(name), class_4943.field_22938);
            itemModelGenerator.method_25733(ModBlockSetsHelper.WOODEN_HANGING_SIGN_ITEMS.get(name), class_4943.field_22938);
        }
        itemModelGenerator.method_25733(ModItems.OLIVES, class_4943.field_22938);
        itemModelGenerator.method_25733(ModBlocks.SERVAL_HIDE.method_8389(), class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.DARKLING_BEETLE_SHELL, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.MARMOT_FUR, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.STEPPE_ARROW, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.STEPPE_EAGLE_FEATHER, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.STEPPE_EAGLE_BEAK, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.STEPPE_VIPER_FANG, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.STEPPE_VIPER_DAGGER, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.SAIGA, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.EARTHWORM, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.SAIGA_HORN, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.COOKED_SAIGA, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.SAIGA_SICKLE, class_4943.field_22938);
        itemModelGenerator.method_25733(ModBlocks.PRAIRIE_SAGE.method_8389(), class_4943.field_22938);
        itemModelGenerator.method_25733(ModBlocks.COTTONWOOD_FLUFF.method_8389(), class_4943.field_22938);
        for (String name : ModBlockSetsHelper.WILD_CROP_NAMES) {
            itemModelGenerator.method_25733(ModBlockSetsHelper.WILD_CROPS.get(name).method_8389(), class_4943.field_22938);
        }
        for (String name : ModBlockSetsHelper.CROP_NAMES) {
            itemModelGenerator.method_25733(ModBlockSetsHelper.CROP_ITEMS.get(name), class_4943.field_22938);
        }
        itemModelGenerator.method_25733(ModItems.BARLEY_BREAD, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.BARLEY_STEW, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.OAT_COOKIE, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.OATMEAL, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.JACKRABBIT, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.COOKED_JACKRABBIT, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.BISON_HORN, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.BISON, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.COOKED_BISON, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.FERRUGINOUS_HAWK_FEATHER, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.PALLID_WINGED_GRASSHOPPER_LEG, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.COOKED_PALLID_WINGED_GRASSHOPPER_LEG, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.BLACK_BILLED_MAGPIE_FEATHER, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.WESTERN_MEADOWLARK_FEATHER, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.PRAIRIES_TALISMAN, class_4943.field_22938);
        this.registerArmor(itemModelGenerator, (class_1738)ModItems.DARKLING_BEETLE_CHESTPLATE);
        this.registerArmor(itemModelGenerator, (class_1738)ModItems.FURRED_LEATHER_HELMET);
        this.registerArmor(itemModelGenerator, (class_1738)ModItems.FURRED_LEATHER_BOOTS);
        this.registerArmor(itemModelGenerator, (class_1738)ModItems.FURRED_LEATHER_CHESTPLATE);
        this.registerArmor(itemModelGenerator, (class_1738)ModItems.FURRED_LEATHER_LEGGINGS);
    }

    public final void registerArmor(class_4915 itemModelGenerator, class_1738 armor) {
        if (armor.method_48398().method_56691()) {
            class_2960 identifier = class_4941.method_25840((class_1792)armor);
            class_2960 identifier2 = class_4944.method_25876((class_1792)armor);
            class_2960 identifier3 = class_4944.method_25863((class_1792)armor, (String)"_overlay");
            if (armor.method_7686().method_55838(ModArmorMaterials.FURRED_LEATHER)) {
                class_4943.field_42232.method_48525(identifier, class_4944.method_48529((class_2960)identifier2, (class_2960)identifier3), itemModelGenerator.field_22844, (id, textures) -> itemModelGenerator.method_48519(id, textures, armor.method_7686()));
            } else {
                class_4943.field_22938.method_48525(identifier, class_4944.method_25895((class_2960)identifier2), itemModelGenerator.field_22844, (id, textures) -> itemModelGenerator.method_48519(id, textures, armor.method_7686()));
            }
            for (TrimMaterial trimMaterial : TRIM_MATERIALS) {
                String string = trimMaterial.getAppliedName((class_6880<class_1741>)armor.method_7686());
                class_2960 identifier4 = itemModelGenerator.method_48518(identifier, string);
                String string2 = armor.method_48398().method_48400() + "_trim_" + string;
                class_2960 identifier5 = class_2960.method_60656((String)string2).method_45138("trims/items/");
                if (armor.method_7686().method_55838(ModArmorMaterials.FURRED_LEATHER)) {
                    itemModelGenerator.method_48742(identifier4, identifier2, identifier3, identifier5);
                    continue;
                }
                itemModelGenerator.method_48517(identifier4, identifier2, identifier5);
            }
        }
    }

    record TrimMaterial(String name, float itemModelIndex, Map<class_6880<class_1741>, String> overrideArmorMaterials) {
        public String getAppliedName(class_6880<class_1741> armorMaterial) {
            return this.overrideArmorMaterials.getOrDefault(armorMaterial, this.name);
        }
    }
}

