/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.wildfields;

import java.util.concurrent.ConcurrentHashMap;
import net.alminoris.wildfields.block.ModBlocks;
import net.alminoris.wildfields.entity.ModBoats;
import net.alminoris.wildfields.entity.ModEntities;
import net.alminoris.wildfields.entity.custom.BisonEntity;
import net.alminoris.wildfields.entity.custom.BlackBilledMagpieEntity;
import net.alminoris.wildfields.entity.custom.CoyoteEntity;
import net.alminoris.wildfields.entity.custom.DarklingBeetleEntity;
import net.alminoris.wildfields.entity.custom.FerruginousHawkEntity;
import net.alminoris.wildfields.entity.custom.MarmotEntity;
import net.alminoris.wildfields.entity.custom.MoleEntity;
import net.alminoris.wildfields.entity.custom.PallidWingedGrasshopperEntity;
import net.alminoris.wildfields.entity.custom.SaigaEntity;
import net.alminoris.wildfields.entity.custom.ServalEntity;
import net.alminoris.wildfields.entity.custom.SteppeEagleEntity;
import net.alminoris.wildfields.entity.custom.SteppeViperEntity;
import net.alminoris.wildfields.entity.custom.WesternMeadowlarkEntity;
import net.alminoris.wildfields.entity.custom.WhiteTailedJackrabbitEntity;
import net.alminoris.wildfields.item.ModItemGroups;
import net.alminoris.wildfields.item.ModItems;
import net.alminoris.wildfields.particle.ModParticles;
import net.alminoris.wildfields.sound.ModSounds;
import net.alminoris.wildfields.util.helper.ModBlockSetsHelper;
import net.alminoris.wildfields.world.gen.ModWorldGeneration;
import net.alminoris.wildfields.world.gen.decorator.ModTreeDecorators;
import net.alminoris.wildfields.world.gen.feature.ModFeatures;
import net.alminoris.wildfields.world.tree.ModFoliagePlacerTypes;
import net.alminoris.wildfields.world.tree.ModTrunkPlacerTypes;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildFields
implements ModInitializer {
    public static final String MOD_ID = "wildfields";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"wildfields");

    public void onInitialize() {
        LOGGER.info("Wild Fields Mod Initialization");
        ModItems.registerModItems();
        ModBlocks.registerModBlocks();
        ModSounds.registerSounds();
        ModParticles.registerParticles();
        for (String name : ModBlockSetsHelper.WOOD_NAMES) {
            StrippableBlockRegistry.register((class_2248)ModBlockSetsHelper.LOGS.get(name), (class_2248)ModBlockSetsHelper.STRIPPED_LOGS.get(name));
            StrippableBlockRegistry.register((class_2248)ModBlockSetsHelper.WOODS.get(name), (class_2248)ModBlockSetsHelper.STRIPPED_WOODS.get(name));
            FlammableBlockRegistry.getDefaultInstance().add(ModBlockSetsHelper.LOGS.get(name), 5, 5);
            FlammableBlockRegistry.getDefaultInstance().add(ModBlockSetsHelper.STRIPPED_LOGS.get(name), 5, 5);
            FlammableBlockRegistry.getDefaultInstance().add(ModBlockSetsHelper.WOODS.get(name), 5, 5);
            FlammableBlockRegistry.getDefaultInstance().add(ModBlockSetsHelper.STRIPPED_WOODS.get(name), 5, 5);
            FlammableBlockRegistry.getDefaultInstance().add(ModBlockSetsHelper.WOODEN_PLANKS.get(name), 5, 20);
            FlammableBlockRegistry.getDefaultInstance().add(ModBlockSetsHelper.LEAVES.get(name), 30, 60);
        }
        FlammableBlockRegistry.getDefaultInstance().add(ModBlocks.TINY_GRASS, 20, 90);
        FlammableBlockRegistry.getDefaultInstance().add(ModBlocks.BLUE_GRAMA_GRASS, 20, 90);
        FlammableBlockRegistry.getDefaultInstance().add(ModBlocks.PRAIRIE_SAGE, 20, 90);
        for (String name : ModBlockSetsHelper.CROP_NAMES) {
            FlammableBlockRegistry.getDefaultInstance().add(ModBlockSetsHelper.HAY_BLOCKS.get(name), 60, 20);
        }
        for (String name : ModBlockSetsHelper.WILD_CROP_NAMES) {
            FlammableBlockRegistry.getDefaultInstance().add(ModBlockSetsHelper.WILD_CROPS.get(name), 30, 40);
        }
        ModBoats.registerBoats();
        ModItemGroups.registerItemGroups();
        ModFeatures.registerFeatures();
        ModTrunkPlacerTypes.register();
        ModFoliagePlacerTypes.register();
        ModTreeDecorators.register();
        ModWorldGeneration.generateModWorldGen();
        FabricDefaultAttributeRegistry.register(ModEntities.MARMOT, (class_5132.class_5133)MarmotEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.STEPPE_EAGLE, (class_5132.class_5133)SteppeEagleEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DARKLING_BEETLE, (class_5132.class_5133)DarklingBeetleEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.STEPPE_VIPER, (class_5132.class_5133)SteppeViperEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SAIGA, (class_5132.class_5133)SaigaEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SERVAL, (class_5132.class_5133)ServalEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.MOLE, (class_5132.class_5133)MoleEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.COYOTE, (class_5132.class_5133)CoyoteEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.FERRUGINOUS_HAWK, (class_5132.class_5133)FerruginousHawkEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.WHITE_TAILED_JACKRABBIT, (class_5132.class_5133)WhiteTailedJackrabbitEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.PALLID_WINGED_GRASSHOPPER, (class_5132.class_5133)PallidWingedGrasshopperEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.BLACK_BILLED_MAGPIE, (class_5132.class_5133)BlackBilledMagpieEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.WESTERN_MEADOWLARK, (class_5132.class_5133)WesternMeadowlarkEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.BISON, (class_5132.class_5133)BisonEntity.setAttributes());
        ConcurrentHashMap LAST_POS = new ConcurrentHashMap();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                class_6880 biome;
                class_243 currPos = player.method_19538();
                class_243 prevPos = (class_243)LAST_POS.get(player.method_5667());
                if (prevPos == null) {
                    LAST_POS.put(player.method_5667(), currPos);
                    continue;
                }
                double dx = currPos.field_1352 - prevPos.field_1352;
                double dy = currPos.field_1351 - prevPos.field_1351;
                double dz = currPos.field_1350 - prevPos.field_1350;
                double horizSq = dx * dx + dz * dz;
                boolean isMoving = horizSq > 1.0E-6;
                boolean isSprinting = player.method_5624();
                boolean isFalling = !player.method_24828() && dy < -0.08;
                class_1799 talismanStack = null;
                int talismanSlot = -1;
                for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                    class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
                    if (!stack.method_31574(ModItems.PRAIRIES_TALISMAN)) continue;
                    talismanStack = stack;
                    talismanSlot = i;
                    break;
                }
                if (talismanStack != null && talismanStack.method_7919() < talismanStack.method_7936() && (biome = player.method_37908().method_23753(player.method_24515())).method_40226(class_2960.method_60655((String)MOD_ID, (String)"prairies_biome"))) {
                    player.method_6092(new class_1293(class_1294.field_5906, 40, 0, true, false, false));
                    player.method_6092(new class_1293(class_1294.field_5904, 40, 0, true, false, false));
                    int damage = 0;
                    if (isFalling) {
                        damage = 10;
                    } else if (isSprinting) {
                        damage = 5;
                    } else if (isMoving) {
                        damage = 2;
                    }
                    if (damage > 0 && player.method_37908().method_8510() % 20L == 0L) {
                        talismanStack.method_7970(damage, (class_1309)player, class_1304.field_6173);
                        if (talismanStack.method_7919() >= talismanStack.method_7936()) {
                            player.method_31548().method_5441(talismanSlot);
                        }
                    }
                }
                LAST_POS.put(player.method_5667(), currPos);
            }
        });
    }
}

