/*
 * Decompiled with CFR 0.152.
 */
package com.xhg78999.shmetro.render;

import com.xhg78999.shmetro.blocks.BlockShanghaiPSDTop;
import com.xhg78999.shmetro.rmg.RMGMain;
import mtr.block.BlockPSDTop;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.DataCache;
import mtr.data.IGui;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public class RenderShanghaiPSDTop<T extends BlockShanghaiPSDTop.TileEntityShanghaiPSDTop>
extends BlockEntityRendererMapper<T>
implements IGui,
IBlock {
    private static final float END_FRONT_OFFSET = 1.0f / (class_3532.field_15724 * 16.0f);
    private static final float BOTTOM_DIAGONAL_OFFSET = ((float)Math.sqrt(3.0) - 1.0f) / 32.0f;
    private static final float ROOT_TWO_SCALED = class_3532.field_15724 / 16.0f;
    private static final float BOTTOM_END_DIAGONAL_OFFSET = END_FRONT_OFFSET - BOTTOM_DIAGONAL_OFFSET / class_3532.field_15724;
    private static final float COLOR_STRIP_START = 0.90625f;
    private static final float COLOR_STRIP_END = 0.9375f;
    protected final float topPadding;
    protected final float bottomPadding;
    protected final float sidePadding;
    private final float z;
    private final boolean transparentWhite;
    private final class_2769<Integer> arrowDirectionProperty = BlockPSDTop.ARROW_DIRECTION;

    public RenderShanghaiPSDTop(class_824 dispatcher) {
        super(dispatcher);
        this.z = 0.121875f;
        this.topPadding = 0.46875f;
        this.bottomPadding = 0.09375f;
        this.sidePadding = 0.0078125f;
        this.transparentWhite = true;
    }

    public final void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        if (world != null) {
            long platformId;
            class_2338 pos = entity.method_11016();
            class_2680 state = world.method_8320(pos);
            class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_2680)state, (class_2769)class_2383.field_11177);
            StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations();
            storedMatrixTransformations.add(matricesNew -> {
                matricesNew.method_22904(0.5 + (double)entity.method_11016().method_10263(), (double)entity.method_11016().method_10264(), 0.5 + (double)entity.method_11016().method_10260());
                UtilitiesClient.rotateYDegrees((class_4587)matricesNew, (float)(-facing.method_10144()));
            });
            if (!RenderTrains.shouldNotRender((class_2338)pos, (int)RenderTrains.maxTrainRenderDistance, (class_2350)null) && (platformId = entity.getPlatformId(ClientData.PLATFORMS, (DataCache)ClientData.DATA_CACHE)) != 0L) {
                storedMatrixTransformations.add(matricesNew -> {
                    matricesNew.method_22904(0.0, 1.0, 0.0);
                    UtilitiesClient.rotateZDegrees((class_4587)matricesNew, (float)180.0f);
                    matricesNew.method_22904(-0.5, (double)(-this.getAdditionalOffset(state)), (double)this.z);
                });
                int leftBlocks = this.getTextureNumber((class_1922)world, pos, facing, true);
                int rightBlocks = this.getTextureNumber((class_1922)world, pos, facing, false);
                int color = RenderShanghaiPSDTop.getShadingColor(facing, -1);
                BlockShanghaiPSDTop.EnumPSDTop renderType = this.getRenderType((class_1922)world, pos.method_10079(facing.method_10160(), leftBlocks), state);
                if (renderType != BlockShanghaiPSDTop.EnumPSDTop.BLANK && IBlock.getStatePropertySafe((class_2680)state, (class_2769)SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
                    float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
                    float height = 1.0f - this.topPadding - this.bottomPadding;
                    int arrowDirection = (Integer)IBlock.getStatePropertySafe((class_2680)state, this.arrowDirectionProperty);
                    class_2960 resourceLocation = renderType == BlockShanghaiPSDTop.EnumPSDTop.RUNIN ? RMGMain.getRuninCache((long)platformId, (boolean)((arrowDirection & 1) > 0 ? true : false), (boolean)(arrowDirection > 1 ? true : false)).resourceLocation : (renderType == BlockShanghaiPSDTop.EnumPSDTop.DESTINATION ? RMGMain.getDestinationCache((long)platformId, (boolean)((arrowDirection & 1) > 0 ? true : false), (boolean)(arrowDirection > 1 ? true : false), (int)((int)(width / height * 400.0f))).resourceLocation : RMGMain.getRailMapCache((long)platformId, (boolean)((arrowDirection & 1) > 0 ? true : false), (boolean)(arrowDirection > 1 ? true : false), (int)((int)(width / height * 400.0f))).resourceLocation);
                    RenderTrains.scheduleRender((class_2960)resourceLocation, (boolean)false, (RenderTrains.QueuedRenderLayer)RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                        storedMatrixTransformations.transform(matricesNew);
                        IDrawing.drawTexture((class_4587)matricesNew, (class_4588)vertexConsumer, (float)(leftBlocks == 0 ? this.sidePadding : 0.0f), (float)this.topPadding, (float)0.0f, (float)(1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f)), (float)(1.0f - this.bottomPadding), (float)0.0f, (float)(((float)leftBlocks - (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width), (float)0.0f, (float)((width - (float)rightBlocks + (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width), (float)1.0f, (class_2350)facing.method_10153(), (int)color, (int)light);
                        matricesNew.method_22909();
                    });
                }
            }
        }
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    protected float getAdditionalOffset(class_2680 state) {
        return 0.0f;
    }

    protected boolean isLeft(class_2680 state) {
        return IBlock.getStatePropertySafe((class_2680)state, (class_2769)SIDE_EXTENDED) == IBlock.EnumSide.LEFT;
    }

    protected boolean isRight(class_2680 state) {
        return IBlock.getStatePropertySafe((class_2680)state, (class_2769)SIDE_EXTENDED) == IBlock.EnumSide.RIGHT;
    }

    protected BlockShanghaiPSDTop.EnumPSDTop getRenderType(class_1922 world, class_2338 pos, class_2680 state) {
        return (BlockShanghaiPSDTop.EnumPSDTop)((Object)IBlock.getStatePropertySafe((class_2680)state, BlockShanghaiPSDTop.KIND));
    }

    private int getTextureNumber(class_1922 world, class_2338 pos, class_2350 facing, boolean searchLeft) {
        class_2680 state;
        int number = 0;
        class_2248 thisBlock = world.method_8320(pos).method_26204();
        while ((state = world.method_8320(pos.method_10079(searchLeft ? facing.method_10160() : facing.method_10170(), number))).method_26204() == thisBlock) {
            boolean isLeft = this.isLeft(state);
            boolean isRight = this.isRight(state);
            if (number != 0 && (searchLeft ? isRight : isLeft)) break;
            ++number;
            if (!(searchLeft ? isLeft : isRight)) continue;
            break;
        }
        return number - 1;
    }

    public static int getShadingColor(class_2350 facing, int grayscaleColorByte) {
        int colorByte = Math.round((float)(grayscaleColorByte & 0xFF) * (facing.method_10166() == class_2350.class_2351.field_11048 ? 0.75f : 1.0f));
        return 0xFF000000 | (colorByte << 16) + (colorByte << 8) + colorByte;
    }
}

