/*
 * Decompiled with CFR 0.152.
 */
package com.xhg78999.shmetro.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.xhg78999.shmetro.resource.GraphicsCache;
import mtr.MTRClient;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.IBlock;
import mtr.data.IGui;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderPSDAPGDoor;
import mtr.render.RenderTrains;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderERailingDoor<T>
extends RenderPSDAPGDoor
implements IGui,
IBlock {
    private final int type;

    public RenderERailingDoor(BlockEntityRenderDispatcher dispatcher, int type) {
        super(dispatcher, type);
        this.type = type;
    }

    public void render(BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world != null) {
            BlockPos pos = entity.m_58899_();
            boolean half = IBlock.getStatePropertySafe((BlockGetter)world, (BlockPos)pos, (Property)BlockPSDAPGDoorBase.HALF) == DoubleBlockHalf.UPPER;
            Direction facing = (Direction)IBlock.getStatePropertySafe((BlockGetter)world, (BlockPos)pos, (Property)BlockPSDAPGDoorBase.f_54117_);
            boolean side = IBlock.getStatePropertySafe((BlockGetter)world, (BlockPos)pos, (Property)BlockPSDAPGDoorBase.SIDE) == IBlock.EnumSide.RIGHT;
            boolean unlocked = (Boolean)IBlock.getStatePropertySafe((BlockGetter)world, (BlockPos)pos, (Property)BlockPSDAPGDoorBase.UNLOCKED);
            float open = Math.min(entity.getOpen(MTRClient.getLastFrameDuration()), 1.0f);
            StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations();
            storedMatrixTransformations.add(matricesNew -> {
                matricesNew.m_85837_(0.5 + (double)entity.m_58899_().m_123341_(), (double)entity.m_58899_().m_123342_(), 0.5 + (double)entity.m_58899_().m_123343_());
                UtilitiesClient.rotateYDegrees((PoseStack)matricesNew, (float)(-facing.m_122435_()));
                UtilitiesClient.rotateXDegrees((PoseStack)matricesNew, (float)180.0f);
            });
            storedMatrixTransformations.add(matricesNew -> matricesNew.m_85837_((double)(open * (float)(side ? -1 : 1)), 0.0, 0.0));
            if (!half) {
                RenderTrains.scheduleRender((ResourceLocation)new ResourceLocation(String.format("shmetro:textures/block/erailing_%s_%s.png", this.type == 114514 ? "1" : "2", side ? "right" : "left")), (boolean)false, (RenderTrains.QueuedRenderLayer)RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform(matricesNew);
                    ((EntityModel)GraphicsCache.CACHE.models.get("erailing_door")).m_7695_(matricesNew, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.m_85849_();
                });
            }
        }
    }
}

