/*
 * Decompiled with CFR 0.152.
 */
package com.xhg78999.shmetro.blocks;

import com.xhg78999.shmetro.BlockEntity;
import com.xhg78999.shmetro.Blocks;
import com.xhg78999.shmetro.network.SHMPacketTrainDataGuiServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mtr.block.IBlock;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class BlockShanghaiSign
extends BlockDirectionalMapper
implements EntityBlockMapper,
IBlock {
    public final int length;
    public final boolean isOdd;
    public static final float SMALL_SIGN_PERCENTAGE = 0.75f;

    public BlockShanghaiSign(int length, boolean isOdd) {
        super(class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_15978).method_29292().method_9632(2.0f).method_9631(state -> 15));
        this.length = length;
        this.isOdd = isOdd;
    }

    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        return IBlock.checkHoldingBrush((class_1937)level, (class_1657)player, () -> {
            class_2338 checkPos;
            class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_2680)blockState, (class_2769)field_11177);
            class_2350 hitSide = blockHitResult.method_17780();
            if ((hitSide == facing || hitSide == facing.method_10153()) && (checkPos = this.findEndWithDirection(level, blockPos, hitSide.method_10153(), false)) != null) {
                SHMPacketTrainDataGuiServer.openSHMSignScreenS2C((class_3222)player, checkPos);
            }
        });
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        boolean isNext;
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_2680)state, (class_2769)field_11177);
        boolean bl = isNext = direction == facing.method_10170() || state.method_27852((class_2248)Blocks.SHM_SIGN_MIDDLE.get()) && direction == facing.method_10160();
        if (isNext && !(newState.method_26204() instanceof BlockShanghaiSign)) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_2350 facing = blockPlaceContext.method_8042();
        return IBlock.isReplaceable((class_1750)blockPlaceContext, (class_2350)facing.method_10170(), (int)(this.getMiddleLength() + 2)) ? (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)facing) : null;
    }

    public void method_9576(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_2680)blockState, (class_2769)field_11177);
        class_2338 checkPos = this.findEndWithDirection(level, blockPos, facing, true);
        if (checkPos != null) {
            IBlock.onBreakCreative((class_1937)level, (class_1657)player, (class_2338)checkPos);
        }
        super.method_9576(level, blockPos, blockState, player);
    }

    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1309 livingEntity, class_1799 itemStack) {
        if (!level.field_9236) {
            class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_2680)blockState, (class_2769)field_11177);
            for (int i = 1; i <= this.getMiddleLength(); ++i) {
                level.method_8652(blockPos.method_10079(facing.method_10170(), i), (class_2680)((class_2248)Blocks.SHM_SIGN_MIDDLE.get()).method_9564().method_11657((class_2769)field_11177, (Comparable)facing), 3);
            }
            level.method_8652(blockPos.method_10079(facing.method_10170(), this.getMiddleLength() + 1), (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)facing.method_10153()), 3);
            level.method_8452(blockPos, class_2246.field_10124);
            blockState.method_30101((class_1936)level, blockPos, 3);
        }
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return class_259.method_1077();
    }

    public class_265 method_9571(class_2680 state, class_1922 level, class_2338 pos) {
        return class_259.method_1073();
    }

    public String method_9539() {
        return "block.shmetro.shm_sign";
    }

    public void method_9568(class_1799 itemStack, class_1922 blockGetter, List<class_2561> tooltip, class_1836 tooltipFlag) {
        tooltip.add((class_2561)Text.translatable((String)"tooltip.mtr.railway_sign_length", (Object[])new Object[]{this.length}).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        tooltip.add((class_2561)Text.translatable((String)(this.isOdd ? "tooltip.mtr.railway_sign_odd" : "tooltip.mtr.railway_sign_even"), (Object[])new Object[0]).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
    }

    public BlockEntityMapper createBlockEntity(class_2338 blockPos, class_2680 blockState) {
        if (this == Blocks.SHM_SIGN_MIDDLE.get()) {
            return null;
        }
        return new TileEntityRailwaySign(this.length, this.isOdd, blockPos, blockState);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }

    public int getXStart() {
        switch (this.length % 4) {
            case 1: {
                return this.isOdd ? 4 : 12;
            }
            case 2: {
                return this.isOdd ? 16 : 8;
            }
            case 3: {
                return this.isOdd ? 12 : 4;
            }
        }
        return this.isOdd ? 8 : 16;
    }

    private int getMiddleLength() {
        return (this.length - (4 - this.getXStart() / 4)) / 2;
    }

    private class_2338 findEndWithDirection(class_1937 world, class_2338 startPos, class_2350 direction, boolean allowOpposite) {
        int i = 0;
        while (true) {
            class_2338 checkPos;
            class_2680 checkState;
            if ((checkState = world.method_8320(checkPos = startPos.method_10079(direction.method_10160(), i))).method_26204() instanceof BlockShanghaiSign) {
                class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_2680)checkState, (class_2769)field_11177);
                if (!checkState.method_27852((class_2248)Blocks.SHM_SIGN_MIDDLE.get()) && (facing == direction || allowOpposite && facing == direction.method_10153())) {
                    return checkPos;
                }
            } else {
                return null;
            }
            ++i;
        }
    }

    public static class TileEntityRailwaySign
    extends BlockEntityClientSerializableMapper {
        private final Set<Long> selectedIds;
        private final String[] signIds;
        private static final String KEY_SELECTED_IDS = "shm_selected_ids";
        private static final String KEY_SIGN_LENGTH = "shm_sign_length";

        public TileEntityRailwaySign(int length, boolean isOdd, class_2338 pos, class_2680 state) {
            super(TileEntityRailwaySign.getType(length, isOdd), pos, state);
            this.signIds = new String[length];
            this.selectedIds = new HashSet<Long>();
        }

        @Environment(value=EnvType.CLIENT)
        public double getViewDistance() {
            return 128.0;
        }

        public void readCompoundTag(class_2487 compoundTag) {
            this.selectedIds.clear();
            Arrays.stream(compoundTag.method_10565(KEY_SELECTED_IDS)).forEach(this.selectedIds::add);
            for (int i = 0; i < this.signIds.length; ++i) {
                String signId = compoundTag.method_10558(KEY_SIGN_LENGTH + i);
                this.signIds[i] = signId.isEmpty() ? null : signId;
            }
        }

        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10538(KEY_SELECTED_IDS, new ArrayList<Long>(this.selectedIds));
            for (int i = 0; i < this.signIds.length; ++i) {
                compoundTag.method_10582(KEY_SIGN_LENGTH + i, this.signIds[i] == null ? "" : this.signIds[i]);
            }
        }

        public void setData(Set<Long> selectedIds, String[] signTypes) {
            this.selectedIds.clear();
            this.selectedIds.addAll(selectedIds);
            if (this.signIds.length == signTypes.length) {
                System.arraycopy(signTypes, 0, this.signIds, 0, signTypes.length);
            }
            this.method_5431();
            this.syncData();
        }

        public Set<Long> getSelectedIds() {
            return this.selectedIds;
        }

        public String[] getSignIds() {
            return this.signIds;
        }

        private static class_2591<?> getType(int length, boolean isOdd) {
            switch (length) {
                case 2: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_2_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_2_EVEN_TILE_ENTITY.get();
                }
                case 3: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_3_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_3_EVEN_TILE_ENTITY.get();
                }
                case 4: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_4_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_4_EVEN_TILE_ENTITY.get();
                }
                case 5: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_5_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_5_EVEN_TILE_ENTITY.get();
                }
                case 6: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_6_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_6_EVEN_TILE_ENTITY.get();
                }
                case 7: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_7_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_7_EVEN_TILE_ENTITY.get();
                }
                case 8: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_8_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_8_EVEN_TILE_ENTITY.get();
                }
                case 9: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_9_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_9_EVEN_TILE_ENTITY.get();
                }
                case 10: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_10_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_10_EVEN_TILE_ENTITY.get();
                }
                case 11: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_11_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_11_EVEN_TILE_ENTITY.get();
                }
                case 12: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_12_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_12_EVEN_TILE_ENTITY.get();
                }
                case 13: {
                    return isOdd ? (class_2591)BlockEntity.SHM_SIGN_13_ODD_TILE_ENTITY.get() : (class_2591)BlockEntity.SHM_SIGN_13_EVEN_TILE_ENTITY.get();
                }
            }
            return null;
        }
    }
}

