/*
 * Decompiled with CFR 0.152.
 */
package com.xhg78999.shmetro.resource;

import com.xhg78999.shmetro.Main;
import com.xhg78999.shmetro.resource.BlockbenchModel;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.io.IOUtils;

public class GraphicsCache {
    public static final GraphicsCache CACHE = new GraphicsCache();
    private final HashMap<String, DynamicResource> dynamicResources = new HashMap();
    private static final class_2960 DEFAULT_WHITE_RESOURCE = new class_2960("mtr", "textures/block/transparent.png");
    private static final DynamicResource DEFAULT_WHITE_DYN_RESOURCE = new DynamicResource(DEFAULT_WHITE_RESOURCE, null);
    public Font font;
    public Font fontCjk;
    public final HashMap<String, BlockbenchModel> models = new HashMap();

    public void reloadDynamic() {
        System.out.println("MTR-SHM: Reloading dynamic resources");
        this.dynamicResources.clear();
    }

    public void reload(class_3300 resourceManager) {
        System.out.println("MTR-SHM: Reloading resources");
        this.reloadDynamic();
        this.models.clear();
        try {
            this.font = Font.createFont(0, Utilities.getInputStream((Optional)resourceManager.method_14486(new class_2960("shmetro", "font/arial.ttf"))));
            this.fontCjk = Font.createFont(0, Utilities.getInputStream((Optional)resourceManager.method_14486(new class_2960("shmetro", "font/simhei.ttf"))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (class_2960 id : resourceManager.method_14488("models/dynamic", path -> path.toString().endsWith(".bbmodel")).keySet()) {
            try {
                GraphicsCache.read(resourceManager, id.toString(), content -> {
                    String name = id.method_12832().replace("models/dynamic/", "").replace(".bbmodel", "");
                    Main.LOGGER.info(String.format("Load Blockbench model %s", name));
                    this.models.put(name, new BlockbenchModel((String)content));
                });
            }
            catch (Exception e) {
                Main.LOGGER.error(String.format("MTR-SHM: ERROR Happened while loading Blockbench Model %s, skipping", id.toString()));
                e.printStackTrace();
            }
        }
    }

    public DynamicResource getResource(String key, Supplier<class_1011> supplier) {
        class_310 minecraftClient = class_310.method_1551();
        DynamicResource dynamicResource = this.dynamicResources.get(key);
        if (dynamicResource != null) {
            return dynamicResource;
        }
        CompletableFuture.runAsync(() -> {
            DynamicResource dynamicResourceNew;
            class_1011 nativeImage = null;
            try {
                nativeImage = (class_1011)supplier.get();
                assert (nativeImage != null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DynamicResource staticTextureProviderOld = this.dynamicResources.get(key);
            if (staticTextureProviderOld != null) {
                staticTextureProviderOld.remove();
            }
            if (nativeImage == null) {
                dynamicResourceNew = DEFAULT_WHITE_DYN_RESOURCE;
            } else {
                class_1043 dynamicTexture = new class_1043(nativeImage);
                String newKey = key;
                try {
                    newKey = URLEncoder.encode(key, StandardCharsets.UTF_8);
                }
                catch (Exception var10) {
                    var10.printStackTrace();
                }
                String var10003 = newKey.toLowerCase(Locale.ENGLISH);
                class_2960 resourceLocation = new class_2960("shmetro", "dynamic_texture_" + var10003.replaceAll("[^0-9a-z_]", "_"));
                minecraftClient.method_1531().method_4616(resourceLocation, (class_1044)dynamicTexture);
                dynamicResourceNew = new DynamicResource(resourceLocation, dynamicTexture);
            }
            this.dynamicResources.put(key, dynamicResourceNew);
        });
        if (dynamicResource == null) {
            this.dynamicResources.put(key, DEFAULT_WHITE_DYN_RESOURCE);
            return DEFAULT_WHITE_DYN_RESOURCE;
        }
        return dynamicResource;
    }

    public static void read(class_3300 manager, String path, Consumer<String> callback) {
        try {
            UtilitiesClient.getResources((class_3300)manager, (class_2960)new class_2960(path)).forEach(resource -> {
                try {
                    InputStream stream = Utilities.getInputStream((class_3298)resource);
                    try {
                        callback.accept(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8));
                    }
                    catch (Throwable var7) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable var6) {
                                var7.addSuppressed(var6);
                            }
                        }
                        throw var7;
                    }
                    stream.close();
                }
                catch (Exception var8) {
                    var8.printStackTrace();
                }
                try {
                    Utilities.closeResource((class_3298)resource);
                }
                catch (IOException var5) {
                    var5.printStackTrace();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class DynamicResource {
        public final int width;
        public final int height;
        public final class_2960 resourceLocation;

        public DynamicResource(class_2960 resourceLocation, class_1043 dynamicTexture) {
            this.resourceLocation = resourceLocation;
            if (dynamicTexture != null) {
                class_1011 nativeImage = dynamicTexture.method_4525();
                if (nativeImage != null) {
                    this.width = nativeImage.method_4307();
                    this.height = nativeImage.method_4323();
                } else {
                    this.width = 16;
                    this.height = 16;
                }
            } else {
                this.width = 16;
                this.height = 16;
            }
        }

        private void remove() {
            if (!this.resourceLocation.equals((Object)DEFAULT_WHITE_RESOURCE)) {
                class_1060 textureManager = class_310.method_1551().method_1531();
                textureManager.method_4615(this.resourceLocation);
                class_1044 abstractTexture = textureManager.method_4619(this.resourceLocation);
                if (abstractTexture != null) {
                    abstractTexture.method_4528();
                    abstractTexture.close();
                }
            }
        }
    }
}

