/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.mixin;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.minecraft.server.Services;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SkullBlockEntity.class})
public abstract class SkullBlockEntityMixin {
    @Inject(method={"fetchProfileByName"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fetchProfileByName(String name, Services services, CallbackInfoReturnable<CompletableFuture<Optional<GameProfile>>> cir) {
        Optional profileOpt = services.profileCache().get(name);
        SkullBlockEntityMixin.skinrestorer$replaceSkin(profileOpt, cir);
    }

    @Inject(method={"fetchProfileById"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fetchProfileById(UUID id, Services services, BooleanSupplier cacheUninitialized, CallbackInfoReturnable<CompletableFuture<Optional<GameProfile>>> cir) {
        Optional profileOpt = services.profileCache().get(id);
        SkullBlockEntityMixin.skinrestorer$replaceSkin(profileOpt, cir);
    }

    @Unique
    private static void skinrestorer$replaceSkin(Optional<GameProfile> profileOpt, CallbackInfoReturnable<CompletableFuture<Optional<GameProfile>>> cir) {
        if (profileOpt.isEmpty()) {
            return;
        }
        GameProfile profile = PlayerUtils.cloneGameProfile(profileOpt.get());
        if (SkinRestorer.getSkinStorage().hasSavedSkin(profile.getId())) {
            cir.setReturnValue(CompletableFuture.supplyAsync(() -> {
                SkinValue skin = SkinRestorer.getSkinStorage().getSkin(profile.getId(), false);
                PlayerUtils.applyRestoredSkin(profile, skin.value());
                return Optional.of(profile);
            }));
        }
    }
}

