/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.config.provider.ElyByProviderConfig;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.util.JsonUtils;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.lionarius.skinrestorer.util.Result;
import net.lionarius.skinrestorer.util.WebUtils;
import net.minecraft.class_3544;
import org.jetbrains.annotations.NotNull;

public final class ElyBySkinProvider
implements SkinProvider {
    public static final String PROVIDER_NAME = "ely.by";
    private static final URI API_URI;
    private static LoadingCache<String, Optional<Property>> SKIN_CACHE;

    public static void reload() {
        ElyBySkinProvider.createCache();
    }

    private static void createCache() {
        ElyByProviderConfig config = SkinRestorer.getConfig().providersConfig().ely_by();
        long time = config.cache().enabled() ? config.cache().duration() : 0L;
        SKIN_CACHE = CacheBuilder.newBuilder().expireAfterWrite(time, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Optional<Property>>(){

            @NotNull
            public Optional<Property> load(@NotNull String key) throws Exception {
                return ElyBySkinProvider.loadSkin(key);
            }
        });
    }

    @Override
    public String getArgumentName() {
        return "username";
    }

    @Override
    public boolean hasVariantSupport() {
        return false;
    }

    @Override
    public Result<Optional<Property>, Exception> fetchSkin(String username, SkinVariant variant) {
        try {
            if (!class_3544.method_57179((String)username)) {
                throw new IllegalArgumentException("invalid username");
            }
            String usernameLowerCase = username.toLowerCase(Locale.ROOT);
            return Result.success((Optional)SKIN_CACHE.get((Object)usernameLowerCase));
        }
        catch (UncheckedExecutionException e) {
            return Result.error((Exception)e.getCause());
        }
        catch (Exception e) {
            return Result.error(e);
        }
    }

    private static Optional<Property> loadSkin(String username) throws Exception {
        GameProfile profile = ElyBySkinProvider.getElyByProfile(username);
        Property textures = PlayerUtils.getPlayerSkin(profile);
        return Optional.ofNullable(textures);
    }

    private static GameProfile getElyByProfile(String username) throws IOException {
        HttpRequest request = HttpRequest.newBuilder().uri(API_URI.resolve("/textures/signed/").resolve(username + "?unsigned=false")).GET().build();
        HttpResponse<String> response = WebUtils.executeRequest(request);
        WebUtils.throwOnClientErrors(response);
        if (response.statusCode() != 200) {
            throw new IllegalArgumentException("no profile with name " + username);
        }
        return JsonUtils.fromJson(response.body(), MinecraftProfilePropertiesResponse.class).profile();
    }

    static {
        try {
            API_URI = new URI("http://skinsystem.ely.by");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

