/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.mineskin;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.mineskin.MineSkinClientImpl;
import org.mineskin.data.CodeAndMessage;
import org.mineskin.exception.MineSkinRequestException;
import org.mineskin.exception.MineskinException;
import org.mineskin.request.RequestHandler;
import org.mineskin.response.MineSkinResponse;
import org.mineskin.response.ResponseConstructor;

public class Java11RequestHandler
extends RequestHandler {
    private final Gson gson;
    private final HttpClient httpClient;

    public Java11RequestHandler(String baseUrl, String userAgent, String apiKey, int timeout, Gson gson, InetSocketAddress proxy) {
        super(baseUrl, userAgent, apiKey, timeout, gson);
        this.gson = gson;
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(timeout));
        if (userAgent != null) {
            clientBuilder.followRedirects(HttpClient.Redirect.NORMAL);
        }
        if (proxy != null) {
            clientBuilder.proxy(ProxySelector.of(proxy));
        }
        this.httpClient = clientBuilder.build();
    }

    private <T, R extends MineSkinResponse<T>> R wrapResponse(HttpResponse<String> response, Class<T> clazz, ResponseConstructor<T, R> constructor) throws IOException {
        String rawBody = response.body();
        try {
            JsonObject jsonBody = (JsonObject)this.gson.fromJson(rawBody, JsonObject.class);
            MineSkinResponse wrapped = constructor.construct(response.statusCode(), this.lowercaseHeaders(response.headers().map()), jsonBody, this.gson, clazz);
            if (!wrapped.isSuccess()) {
                throw new MineSkinRequestException(wrapped.getFirstError().map(CodeAndMessage::code).orElse("request_failed"), wrapped.getFirstError().map(CodeAndMessage::message).orElse("Request Failed"), wrapped);
            }
            return (R)wrapped;
        }
        catch (JsonParseException e) {
            MineSkinClientImpl.LOGGER.log(Level.WARNING, "Failed to parse response body: " + rawBody, e);
            throw new MineskinException("Failed to parse response", (Throwable)e);
        }
    }

    private Map<String, String> lowercaseHeaders(Map<String, List<String>> headers) {
        return headers.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), entry -> String.join((CharSequence)", ", (Iterable)entry.getValue())));
    }

    public <T, R extends MineSkinResponse<T>> R getJson(String url, Class<T> clazz, ResponseConstructor<T, R> constructor) throws IOException {
        HttpResponse<String> response;
        url = this.baseUrl + (String)url;
        MineSkinClientImpl.LOGGER.fine("GET " + (String)url);
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create((String)url)).GET().header("User-Agent", this.userAgent);
        HttpRequest request = this.apiKey != null ? requestBuilder.header("Authorization", "Bearer " + this.apiKey).header("Accept", "application/json").build() : requestBuilder.build();
        try {
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.wrapResponse(response, clazz, constructor);
    }

    public <T, R extends MineSkinResponse<T>> R postJson(String url, JsonObject data, Class<T> clazz, ResponseConstructor<T, R> constructor) throws IOException {
        HttpResponse<String> response;
        url = this.baseUrl + (String)url;
        MineSkinClientImpl.LOGGER.fine("POST " + (String)url);
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create((String)url)).POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson((JsonElement)data))).header("Content-Type", "application/json").header("User-Agent", this.userAgent);
        HttpRequest request = this.apiKey != null ? requestBuilder.header("Authorization", "Bearer " + this.apiKey).header("Accept", "application/json").build() : requestBuilder.build();
        try {
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.wrapResponse(response, clazz, constructor);
    }

    public <T, R extends MineSkinResponse<T>> R postFormDataFile(String url, String key, String filename, InputStream in, Map<String, String> data, Class<T> clazz, ResponseConstructor<T, R> constructor) throws IOException {
        HttpResponse<String> response;
        url = this.baseUrl + (String)url;
        MineSkinClientImpl.LOGGER.fine("POST " + (String)url);
        String boundary = "mineskin-" + System.currentTimeMillis();
        StringBuilder bodyBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            bodyBuilder.append("--").append(boundary).append("\r\n").append("Content-Disposition: form-data; name=\"").append(entry.getKey()).append("\"\r\n\r\n").append(entry.getValue()).append("\r\n");
        }
        byte[] fileContent = in.readAllBytes();
        bodyBuilder.append("--").append(boundary).append("\r\n").append("Content-Disposition: form-data; name=\"").append(key).append("\"; filename=\"").append(filename).append("\"\r\n").append("Content-Type: image/png\r\n\r\n");
        byte[] bodyStart = bodyBuilder.toString().getBytes();
        byte[] boundaryEnd = ("\r\n--" + boundary + "--\r\n").getBytes();
        byte[] bodyString = new byte[bodyStart.length + fileContent.length + boundaryEnd.length];
        System.arraycopy(bodyStart, 0, bodyString, 0, bodyStart.length);
        System.arraycopy(fileContent, 0, bodyString, bodyStart.length, fileContent.length);
        System.arraycopy(boundaryEnd, 0, bodyString, bodyStart.length + fileContent.length, boundaryEnd.length);
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create((String)url)).POST(HttpRequest.BodyPublishers.ofByteArray(bodyString)).header("Content-Type", "multipart/form-data; boundary=" + boundary).header("User-Agent", this.userAgent);
        HttpRequest request = this.apiKey != null ? requestBuilder.header("Authorization", "Bearer " + this.apiKey).header("Accept", "application/json").build() : requestBuilder.build();
        try {
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.wrapResponse(response, clazz, constructor);
    }
}

