/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.compat.skinshuffle;

import com.mojang.authlib.properties.Property;
import java.util.Collections;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshPayload;
import net.lionarius.skinrestorer.platform.Services;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class SkinShuffleCompatibility {
    public static final String MOD_ID = "skinshuffle";
    private static final boolean SHOULD_APPLY = !Services.PLATFORM.isModLoaded("skinshuffle");

    private SkinShuffleCompatibility() {
    }

    public static boolean shouldApply() {
        return SHOULD_APPLY;
    }

    public static ResourceLocation resourceLocation(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void onPlayerJoin(ServerPlayer player) {
        Services.COMPATIBILITY.skinShuffle_sendHandshake(player);
    }

    public static void handleSkinRefresh(MinecraftServer server, ServerPlayer player, SkinShuffleSkinRefreshPayload payload) {
        Property property = payload.textureProperty();
        if (!property.name().equals("textures")) {
            return;
        }
        if (!property.hasSignature()) {
            return;
        }
        server.execute(() -> {
            SkinRestorer.applySkin(server, Collections.singleton(player.m_36316_()), new SkinValue(MOD_ID, null, null, property), !server.m_129797_());
            if (server.m_129797_() && SkinRestorer.getSkinStorage().hasSavedSkin(player.m_20148_())) {
                SkinRestorer.getSkinStorage().deleteSkin(player.m_20148_());
            }
        });
    }
}

