/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.forge.compat.skinshuffle;

import io.netty.buffer.Unpooled;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleCompatibility;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleHandshakePayload;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshPayload;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshV1Payload;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshV2Payload;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.EventNetworkChannel;

public class SkinShufflePacketHandler {
    private static final EventNetworkChannel HANDSHAKE_INSTANCE = ChannelBuilder.named((ResourceLocation)SkinShuffleHandshakePayload.PACKET_ID).optional().eventNetworkChannel();
    private static final EventNetworkChannel SKIN_REFRESH_V1_INSTANCE = ChannelBuilder.named((ResourceLocation)SkinShuffleSkinRefreshV1Payload.PACKET_ID).optional().eventNetworkChannel().addListener(SkinShufflePacketHandler::skinRefreshV1Listener);
    private static final EventNetworkChannel SKIN_REFRESH_V2_INSTANCE = ChannelBuilder.named((ResourceLocation)SkinShuffleSkinRefreshV2Payload.PACKET_ID).optional().eventNetworkChannel().addListener(SkinShufflePacketHandler::skinRefreshV2Listener);

    private SkinShufflePacketHandler() {
    }

    protected static void initialize() {
    }

    public static void sendHandshake(Connection connection) {
        HANDSHAKE_INSTANCE.send((Object)new FriendlyByteBuf(Unpooled.buffer((int)0, (int)0)), connection);
    }

    private static void skinRefreshV1Listener(CustomPayloadEvent event) {
        SkinShuffleSkinRefreshV1Payload payload = SkinShuffleSkinRefreshV1Payload.decode(event.getPayload());
        SkinShufflePacketHandler.handleSkinRefreshPacket(payload, event.getSource());
    }

    private static void skinRefreshV2Listener(CustomPayloadEvent event) {
        SkinShuffleSkinRefreshV2Payload payload = SkinShuffleSkinRefreshV2Payload.decode(event.getPayload());
        SkinShufflePacketHandler.handleSkinRefreshPacket(payload, event.getSource());
    }

    private static void handleSkinRefreshPacket(SkinShuffleSkinRefreshPayload payload, CustomPayloadEvent.Context context) {
        ServerPlayer sender = context.getSender();
        if (!context.isServerSide() || sender == null) {
            return;
        }
        SkinShuffleCompatibility.handleSkinRefresh(sender.m_20194_(), sender, payload);
    }
}

