/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.mixin;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.lionarius.skinrestorer.SkinRestorer;
import net.minecraft.network.Connection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin {
    @Shadow
    @Final
    private MinecraftServer f_11195_;

    @Shadow
    public abstract List<ServerPlayer> m_11314_();

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    private void remove(ServerPlayer player, CallbackInfo ci) {
        SkinRestorer.Events.onPlayerDisconnect(player);
    }

    @Inject(method={"removeAll"}, at={@At(value="HEAD")})
    private void removeAll(CallbackInfo ci) {
        for (ServerPlayer player : this.m_11314_()) {
            SkinRestorer.Events.onPlayerDisconnect(player);
        }
    }

    @Inject(method={"placeNewPlayer"}, at={@At(value="HEAD")})
    private void placeNewPlayer(Connection connection, ServerPlayer player, CommonListenerCookie cookie, CallbackInfo ci) {
        int delay = SkinRestorer.getConfig().skinApplyDelayOnJoin();
        if (delay <= 0) {
            PlayerListMixin.skinrestorer$tryApplySkin(this.f_11195_, player);
        } else {
            UUID uuid = player.m_20148_();
            SkinRestorer.getTickedScheduler().schedule(() -> {
                ServerPlayer actualPlayer = this.f_11195_.m_6846_().m_11259_(uuid);
                if (actualPlayer != null) {
                    PlayerListMixin.skinrestorer$tryApplySkin(this.f_11195_, actualPlayer);
                }
            }, delay, uuid);
        }
    }

    @Unique
    private static void skinrestorer$tryApplySkin(MinecraftServer server, ServerPlayer player) {
        if (SkinRestorer.getSkinStorage().hasSavedSkin(player.m_20148_())) {
            SkinRestorer.applySkin(server, Collections.singleton(player.m_36316_()), SkinRestorer.getSkinStorage().getSkin(player.m_20148_()));
        }
    }
}

