/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.MojangSkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProviderContext;
import net.lionarius.skinrestorer.translation.Translation;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class SkinCommand {
    private SkinCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skin").then(SkinCommand.buildSetSubcommand("clear", SkinValue.EMPTY::toProviderContext))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").executes(context -> SkinCommand.resetSubcommand((CommandSourceStack)context.getSource()))).then(SkinCommand.makeTargetsArgument((context, profiles) -> SkinCommand.resetSubcommand((CommandSourceStack)context.getSource(), profiles, true))))).then(Commands.m_82127_((String)"refresh").executes(context -> SkinCommand.refreshSubcommand((CommandSourceStack)context.getSource())));
        LiteralArgumentBuilder set = Commands.m_82127_((String)"set");
        Collection<Pair<String, SkinProvider>> providers = SkinRestorer.getProvidersRegistry().getPublicProviders();
        for (Pair<String, SkinProvider> entry : providers) {
            set.then(SkinCommand.buildSetSubcommand((String)entry.first(), (SkinProvider)entry.second()));
        }
        if (!providers.isEmpty()) {
            base.then((ArgumentBuilder)set);
        }
        base.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"config").requires(commandSourceStack -> commandSourceStack.m_6761_(4))).then(Commands.m_82127_((String)"reload").executes(SkinCommand::configReloadSubcommand)));
        dispatcher.register(base);
    }

    private static int refreshSubcommand(CommandSourceStack src) {
        ServerPlayer player = src.m_230896_();
        if (player == null) {
            return 0;
        }
        GameProfile profile = player.m_36316_();
        SkinProviderContext context = null;
        boolean save = true;
        if (!SkinRestorer.getSkinStorage().hasSavedSkin(profile.getId())) {
            if (profile.getProperties().containsKey((Object)"textures")) {
                save = false;
                context = MojangSkinProvider.skinProviderContextFromProfile(profile);
            }
        } else {
            context = SkinRestorer.getSkinStorage().getSkin(profile.getId()).toProviderContext();
        }
        if (context == null) {
            return 0;
        }
        return SkinCommand.setSubcommand(src, Collections.singleton(profile), context, save, false);
    }

    private static int resetSubcommand(CommandSourceStack src, Collection<GameProfile> targets, boolean setByOperator) {
        HashSet<ServerPlayer> updatedPlayers = new HashSet<ServerPlayer>();
        for (GameProfile profile : targets) {
            SkinValue skin = null;
            if (SkinRestorer.getSkinStorage().hasSavedSkin(profile.getId())) {
                skin = SkinRestorer.getSkinStorage().getSkin(profile.getId()).replaceValueWithOriginal();
            }
            if (skin == null) continue;
            Collection<ServerPlayer> updatedPlayer = SkinRestorer.applySkin(src.m_81377_(), Collections.singleton(profile), skin, false);
            SkinRestorer.getSkinStorage().deleteSkin(profile.getId());
            updatedPlayers.addAll(updatedPlayer);
        }
        SkinCommand.sendResponse(src, updatedPlayers, setByOperator);
        return targets.size();
    }

    private static int resetSubcommand(CommandSourceStack src) {
        if (src.m_230896_() == null) {
            return 0;
        }
        return SkinCommand.resetSubcommand(src, Collections.singleton(src.m_230896_().m_36316_()), false);
    }

    private static int setSubcommand(CommandSourceStack src, Collection<GameProfile> targets, SkinProviderContext context, boolean save, boolean setByOperator) {
        src.m_243053_((Component)Translation.translatableWithFallback("skinrestorer.command.skin.loading"));
        SkinRestorer.setSkinAsync(src.m_81377_(), targets, context, save).thenAccept(result -> {
            if (result.isError()) {
                src.m_81352_((Component)Translation.translatableWithFallback("skinrestorer.command.skin.failed", result.getErrorValue()));
                return;
            }
            Collection updatedPlayers = (Collection)result.getSuccessValue();
            SkinCommand.sendResponse(src, updatedPlayers, setByOperator);
        });
        return targets.size();
    }

    private static int setSubcommand(CommandSourceStack src, Collection<GameProfile> targets, SkinProviderContext context, boolean setByOperator) {
        return SkinCommand.setSubcommand(src, targets, context, true, setByOperator);
    }

    private static int setSubcommand(CommandSourceStack src, SkinProviderContext context) {
        if (src.m_230896_() == null) {
            return 0;
        }
        return SkinCommand.setSubcommand(src, Collections.singleton(src.m_230896_().m_36316_()), context, false);
    }

    private static int configReloadSubcommand(CommandContext<CommandSourceStack> context) {
        SkinRestorer.reloadConfig();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Translation.translatableWithFallback("skinrestorer.command.skin.config_reloaded"), true);
        return 0;
    }

    private static void sendResponse(CommandSourceStack src, Collection<ServerPlayer> updatedPlayers, boolean setByOperator) {
        if (updatedPlayers.isEmpty()) {
            src.m_81354_((Component)Translation.translatableWithFallback("skinrestorer.command.skin.no_changes"), true);
            return;
        }
        if (setByOperator) {
            Component playersComponent = PlayerUtils.createPlayerListComponent(updatedPlayers);
            src.m_81354_((Component)Translation.translatableWithFallback("skinrestorer.command.skin.affected_players", playersComponent), true);
        } else {
            src.m_81354_((Component)Translation.translatableWithFallback("skinrestorer.command.skin.ok"), true);
        }
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildSetSubcommand(String name, SkinProvider provider) {
        LiteralArgumentBuilder action = Commands.m_82127_((String)name);
        if (provider.hasVariantSupport()) {
            for (SkinVariant variant : SkinVariant.values()) {
                action.then(Commands.m_82127_((String)variant.toString()).then(SkinCommand.buildSetSubcommandArgument(Commands.m_82129_((String)provider.getArgumentName(), (ArgumentType)StringArgumentType.string()), context -> {
                    String argument = StringArgumentType.getString((CommandContext)context, (String)provider.getArgumentName());
                    return new SkinProviderContext(name, argument, variant);
                })));
            }
        } else {
            action.then(SkinCommand.buildSetSubcommandArgument(Commands.m_82129_((String)provider.getArgumentName(), (ArgumentType)StringArgumentType.string()), context -> {
                String argument = StringArgumentType.getString((CommandContext)context, (String)provider.getArgumentName());
                return new SkinProviderContext(name, argument, null);
            }));
        }
        return action;
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> buildSetSubcommand(String name, Supplier<SkinProviderContext> supplier) {
        return SkinCommand.buildSetSubcommandArgument(Commands.m_82127_((String)name), context -> (SkinProviderContext)supplier.get());
    }

    private static <T extends ArgumentBuilder<CommandSourceStack, T>> ArgumentBuilder<CommandSourceStack, T> buildSetSubcommandArgument(ArgumentBuilder<CommandSourceStack, T> argument, Function<CommandContext<CommandSourceStack>, SkinProviderContext> provider) {
        return argument.executes(context -> SkinCommand.setSubcommand((CommandSourceStack)context.getSource(), (SkinProviderContext)provider.apply(context))).then(SkinCommand.makeTargetsArgument((context, targets) -> SkinCommand.setSubcommand((CommandSourceStack)context.getSource(), targets, (SkinProviderContext)provider.apply((CommandContext<CommandSourceStack>)context), true)));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, GameProfileArgument.Result> makeTargetsArgument(BiFunction<CommandContext<CommandSourceStack>, Collection<GameProfile>, Integer> consumer) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).requires(source -> source.m_6761_(2))).executes(context -> (Integer)consumer.apply(context, GameProfileArgument.m_94590_((CommandContext)context, (String)"targets")));
    }
}

