/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.MojangSkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProviderContext;
import net.lionarius.skinrestorer.translation.Translation;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;

public final class SkinCommand {
    private SkinCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"skin").then(SkinCommand.buildSetSubcommand("clear", SkinValue.EMPTY::toProviderContext))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").executes(context -> SkinCommand.resetSubcommand((CommandSourceStack)context.getSource()))).then(SkinCommand.makeTargetsArgument((context, profiles) -> SkinCommand.resetSubcommand((CommandSourceStack)context.getSource(), profiles, true))))).then(Commands.literal((String)"refresh").executes(context -> SkinCommand.refreshSubcommand((CommandSourceStack)context.getSource())));
        LiteralArgumentBuilder set = Commands.literal((String)"set");
        Collection<Pair<String, SkinProvider>> providers = SkinRestorer.getProvidersRegistry().getPublicProviders();
        for (Pair<String, SkinProvider> entry : providers) {
            set.then(SkinCommand.buildSetSubcommand((String)entry.first(), (SkinProvider)entry.second()));
        }
        if (!providers.isEmpty()) {
            base.then((ArgumentBuilder)set);
        }
        base.then(((LiteralArgumentBuilder)Commands.literal((String)"config").requires(commandSourceStack -> commandSourceStack.hasPermission(4))).then(Commands.literal((String)"reload").executes(SkinCommand::configReloadSubcommand)));
        dispatcher.register(base);
    }

    private static int refreshSubcommand(CommandSourceStack src) {
        ServerPlayer player = src.getPlayer();
        if (player == null) {
            return 0;
        }
        GameProfile profile = player.getGameProfile();
        SkinProviderContext context = null;
        boolean save = true;
        if (!SkinRestorer.getSkinStorage().hasSavedSkin(profile.id())) {
            if (profile.properties().containsKey((Object)"textures")) {
                save = false;
                context = MojangSkinProvider.skinProviderContextFromProfile(profile);
            }
        } else {
            context = SkinRestorer.getSkinStorage().getSkin(profile.id()).toProviderContext();
        }
        if (context == null) {
            return 0;
        }
        return SkinCommand.setSubcommand(src, Collections.singleton(new NameAndId(profile)), context, save, false);
    }

    private static int resetSubcommand(CommandSourceStack src, Collection<NameAndId> targets, boolean setByOperator) {
        HashSet<ServerPlayer> updatedPlayers = new HashSet<ServerPlayer>();
        for (NameAndId nameAndId : targets) {
            ServerPlayer player;
            SkinValue skin = null;
            if (SkinRestorer.getSkinStorage().hasSavedSkin(nameAndId.id())) {
                skin = SkinRestorer.getSkinStorage().getSkin(nameAndId.id()).replaceValueWithOriginal();
            }
            if (skin == null || (player = src.getServer().getPlayerList().getPlayer(nameAndId.id())) == null) continue;
            Collection<ServerPlayer> updatedPlayer = SkinRestorer.applySkin(src.getServer(), Collections.singleton(player), skin, false);
            SkinRestorer.getSkinStorage().deleteSkin(nameAndId.id());
            updatedPlayers.addAll(updatedPlayer);
        }
        SkinCommand.sendResponse(src, updatedPlayers, setByOperator);
        return targets.size();
    }

    private static int resetSubcommand(CommandSourceStack src) {
        if (src.getPlayer() == null) {
            return 0;
        }
        return SkinCommand.resetSubcommand(src, Collections.singleton(src.getPlayer().nameAndId()), false);
    }

    private static int setSubcommand(CommandSourceStack src, Collection<NameAndId> targets, SkinProviderContext context, boolean save, boolean setByOperator) {
        src.sendSystemMessage((Component)Translation.translatableWithFallback("skinrestorer.command.skin.loading"));
        List<ServerPlayer> profileTargets = targets.stream().map(nameAndId -> src.getServer().getPlayerList().getPlayer(nameAndId.id())).filter(Objects::nonNull).toList();
        SkinRestorer.setSkinAsync(src.getServer(), profileTargets, context, save).thenAccept(result -> {
            if (result.isError()) {
                src.sendFailure((Component)Translation.translatableWithFallback("skinrestorer.command.skin.failed", result.getErrorValue()));
                return;
            }
            Collection updatedPlayers = (Collection)result.getSuccessValue();
            SkinCommand.sendResponse(src, updatedPlayers, setByOperator);
        });
        return targets.size();
    }

    private static int setSubcommand(CommandSourceStack src, Collection<NameAndId> targets, SkinProviderContext context, boolean setByOperator) {
        return SkinCommand.setSubcommand(src, targets, context, true, setByOperator);
    }

    private static int setSubcommand(CommandSourceStack src, SkinProviderContext context) {
        if (src.getPlayer() == null) {
            return 0;
        }
        return SkinCommand.setSubcommand(src, Collections.singleton(src.getPlayer().nameAndId()), context, false);
    }

    private static int configReloadSubcommand(CommandContext<CommandSourceStack> context) {
        SkinRestorer.reloadConfig();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Translation.translatableWithFallback("skinrestorer.command.skin.config_reloaded"), true);
        return 0;
    }

    private static void sendResponse(CommandSourceStack src, Collection<ServerPlayer> updatedPlayers, boolean setByOperator) {
        if (updatedPlayers.isEmpty()) {
            src.sendSuccess(() -> Translation.translatableWithFallback("skinrestorer.command.skin.no_changes"), true);
            return;
        }
        if (setByOperator) {
            Component playersComponent = PlayerUtils.createPlayerListComponent(updatedPlayers);
            src.sendSuccess(() -> Translation.translatableWithFallback("skinrestorer.command.skin.affected_players", playersComponent), true);
        } else {
            src.sendSuccess(() -> Translation.translatableWithFallback("skinrestorer.command.skin.ok"), true);
        }
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildSetSubcommand(String name, SkinProvider provider) {
        LiteralArgumentBuilder action = Commands.literal((String)name);
        if (provider.hasVariantSupport()) {
            for (SkinVariant variant : SkinVariant.values()) {
                action.then(Commands.literal((String)variant.toString()).then(SkinCommand.buildSetSubcommandArgument(Commands.argument((String)provider.getArgumentName(), (ArgumentType)StringArgumentType.string()), context -> {
                    String argument = StringArgumentType.getString((CommandContext)context, (String)provider.getArgumentName());
                    return new SkinProviderContext(name, argument, variant);
                })));
            }
        } else {
            action.then(SkinCommand.buildSetSubcommandArgument(Commands.argument((String)provider.getArgumentName(), (ArgumentType)StringArgumentType.string()), context -> {
                String argument = StringArgumentType.getString((CommandContext)context, (String)provider.getArgumentName());
                return new SkinProviderContext(name, argument, null);
            }));
        }
        return action;
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> buildSetSubcommand(String name, Supplier<SkinProviderContext> supplier) {
        return SkinCommand.buildSetSubcommandArgument(Commands.literal((String)name), context -> (SkinProviderContext)supplier.get());
    }

    private static <T extends ArgumentBuilder<CommandSourceStack, T>> ArgumentBuilder<CommandSourceStack, T> buildSetSubcommandArgument(ArgumentBuilder<CommandSourceStack, T> argument, Function<CommandContext<CommandSourceStack>, SkinProviderContext> provider) {
        return argument.executes(context -> SkinCommand.setSubcommand((CommandSourceStack)context.getSource(), (SkinProviderContext)provider.apply(context))).then(SkinCommand.makeTargetsArgument((context, targets) -> SkinCommand.setSubcommand((CommandSourceStack)context.getSource(), targets, (SkinProviderContext)provider.apply((CommandContext<CommandSourceStack>)context), true)));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, GameProfileArgument.Result> makeTargetsArgument(BiFunction<CommandContext<CommandSourceStack>, Collection<NameAndId>, Integer> consumer) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).requires(source -> source.hasPermission(2))).executes(context -> (Integer)consumer.apply(context, GameProfileArgument.getGameProfiles((CommandContext)context, (String)"targets")));
    }
}

