/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.MojangSkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProviderContext;
import net.lionarius.skinrestorer.translation.Translation;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class SkinCommand {
    private SkinCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skin").then(SkinCommand.buildSetSubcommand("clear", SkinValue.EMPTY::toProviderContext))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").executes(context -> SkinCommand.resetSubcommand((class_2168)context.getSource()))).then(SkinCommand.makeTargetsArgument((context, profiles) -> SkinCommand.resetSubcommand((class_2168)context.getSource(), profiles, true))))).then(class_2170.method_9247((String)"refresh").executes(context -> SkinCommand.refreshSubcommand((class_2168)context.getSource())));
        LiteralArgumentBuilder set = class_2170.method_9247((String)"set");
        Collection<Pair<String, SkinProvider>> providers = SkinRestorer.getProvidersRegistry().getPublicProviders();
        for (Pair<String, SkinProvider> entry : providers) {
            set.then(SkinCommand.buildSetSubcommand((String)entry.first(), (SkinProvider)entry.second()));
        }
        if (!providers.isEmpty()) {
            base.then((ArgumentBuilder)set);
        }
        base.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(commandSourceStack -> commandSourceStack.method_9259(4))).then(class_2170.method_9247((String)"reload").executes(SkinCommand::configReloadSubcommand)));
        dispatcher.register(base);
    }

    private static int refreshSubcommand(class_2168 src) {
        class_3222 player = src.method_44023();
        if (player == null) {
            return 0;
        }
        GameProfile profile = player.method_7334();
        SkinProviderContext context = null;
        boolean save = true;
        if (!SkinRestorer.getSkinStorage().hasSavedSkin(profile.getId())) {
            if (profile.getProperties().containsKey((Object)"textures")) {
                save = false;
                context = MojangSkinProvider.skinProviderContextFromProfile(profile);
            }
        } else {
            context = SkinRestorer.getSkinStorage().getSkin(profile.getId()).toProviderContext();
        }
        if (context == null) {
            return 0;
        }
        return SkinCommand.setSubcommand(src, Collections.singleton(profile), context, save, false);
    }

    private static int resetSubcommand(class_2168 src, Collection<GameProfile> targets, boolean setByOperator) {
        HashSet<class_3222> updatedPlayers = new HashSet<class_3222>();
        for (GameProfile profile : targets) {
            SkinValue skin = null;
            if (SkinRestorer.getSkinStorage().hasSavedSkin(profile.getId())) {
                skin = SkinRestorer.getSkinStorage().getSkin(profile.getId()).replaceValueWithOriginal();
            }
            if (skin == null) continue;
            Collection<class_3222> updatedPlayer = SkinRestorer.applySkin(src.method_9211(), Collections.singleton(profile), skin, false);
            SkinRestorer.getSkinStorage().deleteSkin(profile.getId());
            updatedPlayers.addAll(updatedPlayer);
        }
        SkinCommand.sendResponse(src, updatedPlayers, setByOperator);
        return targets.size();
    }

    private static int resetSubcommand(class_2168 src) {
        if (src.method_44023() == null) {
            return 0;
        }
        return SkinCommand.resetSubcommand(src, Collections.singleton(src.method_44023().method_7334()), false);
    }

    private static int setSubcommand(class_2168 src, Collection<GameProfile> targets, SkinProviderContext context, boolean save, boolean setByOperator) {
        src.method_45068((class_2561)Translation.translatableWithFallback("skinrestorer.command.skin.loading"));
        SkinRestorer.setSkinAsync(src.method_9211(), targets, context, save).thenAccept(result -> {
            if (result.isError()) {
                src.method_9213((class_2561)Translation.translatableWithFallback("skinrestorer.command.skin.failed", result.getErrorValue()));
                return;
            }
            Collection updatedPlayers = (Collection)result.getSuccessValue();
            SkinCommand.sendResponse(src, updatedPlayers, setByOperator);
        });
        return targets.size();
    }

    private static int setSubcommand(class_2168 src, Collection<GameProfile> targets, SkinProviderContext context, boolean setByOperator) {
        return SkinCommand.setSubcommand(src, targets, context, true, setByOperator);
    }

    private static int setSubcommand(class_2168 src, SkinProviderContext context) {
        if (src.method_44023() == null) {
            return 0;
        }
        return SkinCommand.setSubcommand(src, Collections.singleton(src.method_44023().method_7334()), context, false);
    }

    private static int configReloadSubcommand(CommandContext<class_2168> context) {
        SkinRestorer.reloadConfig();
        ((class_2168)context.getSource()).method_9226((class_2561)Translation.translatableWithFallback("skinrestorer.command.skin.config_reloaded"), true);
        return 0;
    }

    private static void sendResponse(class_2168 src, Collection<class_3222> updatedPlayers, boolean setByOperator) {
        if (updatedPlayers.isEmpty()) {
            src.method_9226((class_2561)Translation.translatableWithFallback("skinrestorer.command.skin.no_changes"), true);
            return;
        }
        if (setByOperator) {
            class_2561 playersComponent = PlayerUtils.createPlayerListComponent(updatedPlayers);
            src.method_9226((class_2561)Translation.translatableWithFallback("skinrestorer.command.skin.affected_players", playersComponent), true);
        } else {
            src.method_9226((class_2561)Translation.translatableWithFallback("skinrestorer.command.skin.ok"), true);
        }
    }

    private static LiteralArgumentBuilder<class_2168> buildSetSubcommand(String name, SkinProvider provider) {
        LiteralArgumentBuilder action = class_2170.method_9247((String)name);
        if (provider.hasVariantSupport()) {
            for (SkinVariant variant : SkinVariant.values()) {
                action.then(class_2170.method_9247((String)variant.toString()).then(SkinCommand.buildSetSubcommandArgument(class_2170.method_9244((String)provider.getArgumentName(), (ArgumentType)StringArgumentType.string()), context -> {
                    String argument = StringArgumentType.getString((CommandContext)context, (String)provider.getArgumentName());
                    return new SkinProviderContext(name, argument, variant);
                })));
            }
        } else {
            action.then(SkinCommand.buildSetSubcommandArgument(class_2170.method_9244((String)provider.getArgumentName(), (ArgumentType)StringArgumentType.string()), context -> {
                String argument = StringArgumentType.getString((CommandContext)context, (String)provider.getArgumentName());
                return new SkinProviderContext(name, argument, null);
            }));
        }
        return action;
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> buildSetSubcommand(String name, Supplier<SkinProviderContext> supplier) {
        return SkinCommand.buildSetSubcommandArgument(class_2170.method_9247((String)name), context -> (SkinProviderContext)supplier.get());
    }

    private static <T extends ArgumentBuilder<class_2168, T>> ArgumentBuilder<class_2168, T> buildSetSubcommandArgument(ArgumentBuilder<class_2168, T> argument, Function<CommandContext<class_2168>, SkinProviderContext> provider) {
        return argument.executes(context -> SkinCommand.setSubcommand((class_2168)context.getSource(), (SkinProviderContext)provider.apply(context))).then(SkinCommand.makeTargetsArgument((context, targets) -> SkinCommand.setSubcommand((class_2168)context.getSource(), targets, (SkinProviderContext)provider.apply((CommandContext<class_2168>)context), true)));
    }

    private static RequiredArgumentBuilder<class_2168, class_2191.class_2192> makeTargetsArgument(BiFunction<CommandContext<class_2168>, Collection<GameProfile>, Integer> consumer) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).requires(source -> source.method_9259(2))).executes(context -> (Integer)consumer.apply(context, class_2191.method_9330((CommandContext)context, (String)"targets")));
    }
}

