/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin;

import com.mojang.authlib.properties.Property;
import java.util.Objects;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.SkinProviderContext;
import net.lionarius.skinrestorer.util.gson.GsonPostProcessable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SkinValue
implements GsonPostProcessable {
    public static final SkinValue EMPTY = new SkinValue("empty", null, null, null);
    @NotNull
    private String provider;
    @Nullable
    private String argument;
    @Nullable
    private SkinVariant variant;
    @Nullable
    private Property value;
    @Nullable
    private Property originalValue;

    public SkinValue(@NotNull String provider, @Nullable String argument, @Nullable SkinVariant variant, @Nullable Property value, @Nullable Property originalValue) {
        this.provider = provider;
        this.argument = argument;
        this.variant = variant;
        this.value = value;
        this.originalValue = originalValue;
    }

    public SkinValue(String provider, String argument, SkinVariant variant, Property value) {
        this(provider, argument, variant, value, null);
    }

    public static SkinValue fromProviderContextWithValue(SkinProviderContext context, Property value) {
        return new SkinValue(context.name(), context.argument(), context.variant(), value);
    }

    public SkinProviderContext toProviderContext() {
        return new SkinProviderContext(this.provider, this.argument, this.variant);
    }

    public SkinValue replaceValueWithOriginal() {
        return new SkinValue(this.provider, this.argument, this.variant, this.originalValue, this.originalValue);
    }

    public SkinValue setOriginalValue(Property originalValue) {
        return new SkinValue(this.provider, this.argument, this.variant, this.value, originalValue);
    }

    @Override
    public void gsonPostProcess() {
        Objects.requireNonNull(this.provider);
    }

    @NotNull
    public String provider() {
        return this.provider;
    }

    @Nullable
    public String argument() {
        return this.argument;
    }

    @Nullable
    public SkinVariant variant() {
        return this.variant;
    }

    @Nullable
    public Property value() {
        return this.value;
    }

    @Nullable
    public Property originalValue() {
        return this.originalValue;
    }
}

