/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.translation;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.util.FileUtils;
import net.lionarius.skinrestorer.util.JsonUtils;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class Translation {
    public static final String LEGACY_TRANSLATION_FILENAME = "translation";
    public static final String COMMAND_SKIN_AFFECTED_PLAYERS_KEY = "skinrestorer.command.skin.affected_players";
    public static final String COMMAND_SKIN_NO_CHANGES_KEY = "skinrestorer.command.skin.no_changes";
    public static final String COMMAND_SKIN_FAILED_KEY = "skinrestorer.command.skin.failed";
    public static final String COMMAND_SKIN_OK_KEY = "skinrestorer.command.skin.ok";
    public static final String COMMAND_SKIN_LOADING_KEY = "skinrestorer.command.skin.loading";
    public static final String COMMAND_SKIN_CONFIG_RELOADED_KEY = "skinrestorer.command.skin.config_reloaded";
    private static Map<String, String> translations;
    private static final Map<String, String> fallback;

    private Translation() {
    }

    public static String get(String key) {
        String value = translations.get(key);
        if (value == null) {
            value = fallback.get(key);
        }
        return value;
    }

    public static class_5250 translatableWithFallback(String key) {
        return class_2561.method_43471((String)Translation.get(key));
    }

    public static class_5250 translatableWithFallback(String key, Object ... args) {
        return class_2561.method_43469((String)Translation.get(key), (Object[])args);
    }

    public static void reloadTranslations() {
        translations = Translation.loadTranslationMap(SkinRestorer.getConfig().language());
    }

    private static ImmutableMap<String, String> loadTranslationMap(String lang) {
        String json = FileUtils.readResource(SkinRestorer.assetPath(String.format("lang/%s.json", lang)));
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map map = null;
        try {
            map = (Map)JsonUtils.fromJson(Objects.requireNonNull(json), type);
        }
        catch (Exception e) {
            SkinRestorer.LOGGER.error("Failed to load translation map", (Throwable)e);
        }
        if (map == null) {
            return ImmutableMap.builder().build();
        }
        return ImmutableMap.copyOf((Map)map);
    }

    static {
        fallback = Translation.loadTranslationMap("en_us");
    }
}

