/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.lionarius.skinrestorer.mixin.ChunkMapAccessor;
import net.lionarius.skinrestorer.mixin.TrackedEntityAccessorInvoker;
import net.lionarius.skinrestorer.util.JsonUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;

public final class PlayerUtils {
    public static final String TEXTURES_KEY = "textures";

    private PlayerUtils() {
    }

    public static Component createPlayerListComponent(Collection<ServerPlayer> players) {
        MutableComponent component = Component.empty();
        int index = 0;
        for (ServerPlayer player : players) {
            component.append(Objects.requireNonNull(player.getDisplayName()));
            if (++index >= players.size()) continue;
            component.append(", ");
        }
        return component;
    }

    public static boolean isFakePlayer(ServerPlayer player) {
        return player.getClass() != ServerPlayer.class;
    }

    public static void refreshPlayer(ServerPlayer player) {
        ServerLevel serverLevel = player.serverLevel();
        PlayerList playerList = serverLevel.getServer().getPlayerList();
        ChunkMap chunkMap = serverLevel.getChunkSource().chunkMap;
        playerList.broadcastAll((Packet)new ClientboundBundlePacket(List.of(new ClientboundPlayerInfoRemovePacket(List.of(player.getUUID())), ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(Collections.singleton(player)))));
        TrackedEntityAccessorInvoker trackedEntity = (TrackedEntityAccessorInvoker)((ChunkMapAccessor)chunkMap).getEntityMap().get(player.getId());
        if (trackedEntity != null) {
            Set<ServerPlayerConnection> seenBy = Set.copyOf(trackedEntity.getSeenBy());
            for (ServerPlayerConnection observerConnection : seenBy) {
                ServerPlayer observer = observerConnection.getPlayer();
                trackedEntity.invokeRemovePlayer(observer);
                TrackedEntityAccessorInvoker trackedObserverEntity = (TrackedEntityAccessorInvoker)((ChunkMapAccessor)chunkMap).getEntityMap().get(observer.getId());
                if (trackedObserverEntity != null) {
                    trackedObserverEntity.invokeRemovePlayer(player);
                    trackedObserverEntity.invokeUpdatePlayer(player);
                }
                trackedEntity.invokeUpdatePlayer(observer);
            }
        }
        if (!player.isDeadOrDying()) {
            player.connection.send((Packet)new ClientboundBundlePacket(List.of(new ClientboundRespawnPacket(player.createCommonSpawnInfo(serverLevel), 3), new ClientboundGameEventPacket(ClientboundGameEventPacket.LEVEL_CHUNKS_LOAD_START, 0.0f))));
            player.connection.teleport(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
            player.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
            Entity vehicle = player.getVehicle();
            if (vehicle != null) {
                player.connection.send((Packet)new ClientboundSetPassengersPacket(vehicle));
            }
            if (!player.getPassengers().isEmpty()) {
                player.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)player));
            }
            player.onUpdateAbilities();
            player.giveExperiencePoints(0);
            playerList.sendPlayerPermissionLevel(player);
            playerList.sendLevelInfo(player, serverLevel);
            playerList.sendAllPlayerInfo(player);
            playerList.sendActivePlayerEffects(player);
        }
    }

    private static void sendActivePlayerEffects(ServerPlayer player) {
        for (MobEffectInstance effect : player.getActiveEffects()) {
            player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(player.getId(), effect, false));
        }
    }

    public static GameProfile cloneGameProfile(GameProfile profile) {
        GameProfile newProfile = new GameProfile(profile.getId(), profile.getName());
        newProfile.getProperties().putAll((Multimap)profile.getProperties());
        return newProfile;
    }

    public static Property getPlayerSkin(GameProfile profile) {
        return (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)TEXTURES_KEY), null);
    }

    public static void applyRestoredSkin(GameProfile profile, Property skin) {
        profile.getProperties().removeAll((Object)TEXTURES_KEY);
        if (skin != null) {
            profile.getProperties().put((Object)TEXTURES_KEY, (Object)skin);
        }
    }

    public static boolean areSkinPropertiesEquals(Property x, Property y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.equals((Object)y)) {
            return true;
        }
        JsonObject xJson = JsonUtils.skinPropertyToJson(x);
        JsonObject yJson = JsonUtils.skinPropertyToJson(y);
        if (xJson == null || yJson == null) {
            return false;
        }
        return xJson.equals((Object)yJson);
    }

    public static GameProfile toProfile(MinecraftProfilePropertiesResponse response) {
        GameProfile profile = new GameProfile(response.id(), response.name());
        profile.getProperties().putAll((Multimap)response.properties());
        return profile;
    }
}

